/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.provider;

import es.prodevelop.gvsig.mini.common.IBitmap;
import es.prodevelop.gvsig.mini.common.IContext;
import es.prodevelop.gvsig.mini.common.IEvent;
import es.prodevelop.gvsig.mini.common.IHandler;
import es.prodevelop.gvsig.mini.common.impl.Tile;
import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.map.GeoUtils;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import es.prodevelop.gvsig.mini.utiles.WorkQueue;
import es.prodevelop.tilecache.draw.TileDrawer;
import es.prodevelop.tilecache.provider.Downloader;
import es.prodevelop.tilecache.provider.TileCache;
import es.prodevelop.tilecache.provider.event.TileEvent;
import es.prodevelop.tilecache.provider.filesystem.ITileFileSystemProvider;
import es.prodevelop.tilecache.provider.filesystem.impl.TileFilesystemProvider;
import es.prodevelop.tilecache.provider.filesystem.strategy.ITileFileSystemStrategy;
import es.prodevelop.tilecache.util.ConstantsTileCache;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TileProvider
implements GeoUtils {
    public static int NUM_RETRY = 2;
    public static final int MODE_ONLINE = 0;
    public static final int MODE_OFFLINE = 1;
    public static final int MODE_UPDATE = 2;
    public static final int MODE_DELETE = 3;
    public static final int MODE_CONNECTED = 4;
    public boolean NOT_LOCAL_CACHE = false;
    public IBitmap mLoadingMapTile = null;
    public IBitmap mOfflineMapTile = null;
    protected IContext mCtx;
    String datalog = null;
    protected TileCache mTileCache;
    protected ITileFileSystemProvider mFSTileProvider;
    protected Downloader mTileDownloader;
    protected IHandler mLoadCallbackHandler;
    private static final Logger log = Logger.getLogger("TileProvider");
    protected int loadingTileID;
    protected int offlineTileID;
    private int mode;
    protected int lastZoomLevelRequested = -1;
    private Extent viewExtent;

    public TileProvider(IContext ctx, IHandler aLoadCallbackHandler, int width, int height, int tileSize, int mode, ITileFileSystemStrategy fileSystemStrategy) {
        try {
            this.mode = mode;
            this.loadingTileID = ctx.getDefaultLoadingTileID();
            this.offlineTileID = ctx.getDefaultOfflineTileID();
            this.mLoadCallbackHandler = aLoadCallbackHandler;
            this.mCtx = ctx;
            WorkQueue.getInstance((int)ConstantsTileCache.DEFAULT_NUM_THREADS);
            try {
                this.mLoadingMapTile = this.mCtx.getBitmapFromResource(this.loadingTileID);
                this.mOfflineMapTile = this.mCtx.getBitmapFromResource(this.offlineTileID);
            }
            catch (OutOfMemoryError e) {
                System.gc();
                log.log(Level.SEVERE, "", e);
                this.onLowMemory();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
            }
            if (!this.NOT_LOCAL_CACHE) {
                this.mTileCache = new TileCache(width, height, tileSize);
            }
            this.mFSTileProvider = new TileFilesystemProvider(0x400000, this.mTileCache, ctx, fileSystemStrategy, mode, this.mOfflineMapTile);
            this.mTileDownloader = new Downloader(ctx, this.mFSTileProvider);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public TileProvider(IContext ctx, IHandler aLoadCallbackHandler, int width, int height, int tileSize, int mode, ITileFileSystemStrategy fileSystemStrategy, boolean notLocalCache) {
        this(ctx, aLoadCallbackHandler, width, height, tileSize, mode, fileSystemStrategy);
        try {
            this.NOT_LOCAL_CACHE = notLocalCache;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public void clearPendingQueue() {
        try {
            this.mFSTileProvider.getPendingQueue().clear();
            this.mTileDownloader.mPending.clear();
            WorkQueue.getInstance().clearPendingTasks();
            this.mCtx.sendMessage(this.mLoadCallbackHandler, -1);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public IBitmap getMapTileFromCache(Tile tile, Cancellable cancellable) {
        try {
            String cacheURL = tile.getTileString();
            if (this.mTileCache == null) {
                return null;
            }
            IBitmap b = this.mTileCache.getMapTile(cacheURL);
            if (b == null && this.mode == 1) {
                return this.mOfflineMapTile;
            }
            return b;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return this.mLoadingMapTile;
        }
    }

    public IBitmap getMapTile(Tile tile, Cancellable cancellable) {
        try {
            return this.getMapTile(tile, cancellable, null);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return this.mLoadingMapTile;
        }
    }

    public IBitmap getMapTile(Tile tile, Cancellable cancellable, TileDrawer drawer) {
        try {
            boolean prepend;
            boolean returnLoadingTile = false;
            String cacheURL = tile.getTileString();
            IBitmap ret = null;
            if (this.mTileCache != null) {
                ret = this.mTileCache.getMapTile(cacheURL);
            }
            if (ret != null) {
                this.mCtx.sendMessage(this.mLoadCallbackHandler, (IEvent)this.instantiateEvent(tile), 999);
                if (drawer != null) {
                    drawer.drawTile(tile.clone(), ret);
                }
                return ret;
            }
            boolean bl = prepend = this.lastZoomLevelRequested == tile.zoomLevel;
            if (this.lastZoomLevelRequested == -1 || prepend || this.mode == 1) {
                returnLoadingTile = true;
                this.setViewExtent(null);
            }
            try {
                ret = this.mCtx.isSDMounted() ? (!this.mFSTileProvider.getPendingQueue().contains(cacheURL) ? (this.mFSTileProvider.loadMapTileToMemCacheAsync(tile, this.mLoadCallbackHandler, cacheURL, cancellable, drawer, prepend) ? (this.mode == 1 ? this.mOfflineMapTile : this.mLoadingMapTile) : this.downloadFromServer(tile, cacheURL, cancellable, drawer, prepend)) : (this.mode == 1 ? this.mOfflineMapTile : this.mLoadingMapTile)) : this.downloadFromServer(tile, cacheURL, cancellable, drawer, prepend);
            }
            catch (Exception e) {
                ret = this.downloadFromServer(tile, cacheURL, cancellable, drawer, prepend);
                e.printStackTrace();
            }
            if (returnLoadingTile) {
                return ret;
            }
            return null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return this.mLoadingMapTile;
        }
    }

    public IBitmap downloadFromServer(Tile tile, String cacheURL, Cancellable cancellable, TileDrawer drawer, boolean prepend) {
        if (this.mode != 1 && this.mode != 3) {
            this.mTileDownloader.requestMapTileAsync(tile, this.mLoadCallbackHandler, cacheURL, cancellable, drawer, prepend);
            return this.mLoadingMapTile;
        }
        this.mCtx.sendMessage(this.mLoadCallbackHandler, (IEvent)this.mTileDownloader.instantiateEvent(tile), 0);
        if (drawer != null) {
            drawer.drawTile(tile.clone(), this.mOfflineMapTile);
        }
        this.mTileDownloader.mPending.remove(cacheURL);
        if (this.mFSTileProvider.getPendingQueue().contains(cacheURL)) {
            return null;
        }
        return this.mOfflineMapTile;
    }

    public void onLowMemory() {
        try {
            if (this.mTileCache != null) {
                this.mTileCache.onLowMemory();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public void destroy() {
        try {
            this.mLoadingMapTile = null;
            if (this.mTileCache != null) {
                this.mTileCache.destroy();
            }
            this.mTileCache = null;
            this.mFSTileProvider.destroy();
            this.mFSTileProvider = null;
            this.mTileDownloader = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public ITileFileSystemProvider getMFSTileProvider() {
        return this.mFSTileProvider;
    }

    public void setMFSTileProvider(ITileFileSystemProvider tileProvider) {
        this.mFSTileProvider = tileProvider;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.getMFSTileProvider().setMode(mode);
    }

    protected TileEvent instantiateEvent(Tile aTile) {
        return new TileEvent(aTile.clone(), "", this.getMode(), this.mFSTileProvider.getStrategy().getName(), 1);
    }

    public void setLastZoomLevelRequested(int lastZoomLevelRequested) {
        this.lastZoomLevelRequested = lastZoomLevelRequested;
    }

    public void setViewExtent(Extent viewExtent) {
        this.viewExtent = viewExtent;
        this.mTileDownloader.setViewExtent(viewExtent);
    }

    public Downloader getDownloader() {
        return this.mTileDownloader;
    }
}

