/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.provider.filesystem.impl;

import es.prodevelop.gvsig.mini.common.IBitmap;
import es.prodevelop.gvsig.mini.common.IContext;
import es.prodevelop.gvsig.mini.common.IEvent;
import es.prodevelop.gvsig.mini.common.IHandler;
import es.prodevelop.gvsig.mini.common.impl.Tile;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import es.prodevelop.gvsig.mini.utiles.Constants;
import es.prodevelop.gvsig.mini.utiles.WorkQueue;
import es.prodevelop.tilecache.draw.TileDrawer;
import es.prodevelop.tilecache.provider.TileCache;
import es.prodevelop.tilecache.provider.TileProvider;
import es.prodevelop.tilecache.provider.filesystem.impl.TileFilesystemProvider;
import es.prodevelop.tilecache.provider.filesystem.strategy.ITileFileSystemStrategy;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BackgroundFileSystemProvider
extends TileFilesystemProvider {
    private TileProvider tileProvider;

    public BackgroundFileSystemProvider(int maxFSCacheByteSize, TileCache cache, IContext context, ITileFileSystemStrategy strategy, int mode, IBitmap offlineBitmap, TileProvider tileProvider) {
        super(maxFSCacheByteSize, cache, context, strategy, mode, offlineBitmap);
        this.tileProvider = tileProvider;
    }

    public synchronized boolean loadMapTileToMemCacheAsync(final Tile tile, final IHandler callback, final String cacheURL, final Cancellable cancellable, final TileDrawer drawer, final boolean prepend) throws IOException {
        if (this.mPending.contains(cacheURL)) {
            return true;
        }
        if (this.mode == 4) {
            return false;
        }
        this.mPending.add(cacheURL);
        WorkQueue.getInstance().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                BufferedOutputStream out = null;
                ByteArrayOutputStream dataStream = null;
                boolean succeed = false;
                int retryCount = 0;
                String quadDir = BackgroundFileSystemProvider.this.strategy.getRelativeToLayerDirTilePath(tile.tile, tile.zoomLevel);
                String st = BackgroundFileSystemProvider.this.getSDDir();
                File f = new File(new StringBuffer().append(st).append(File.separator).append("gvSIG").append(File.separator).append("maps").append(File.separator).append(tile.layerName).append(BackgroundFileSystemProvider.this.strategy.getLayerNameSuffix()).append(File.separator).append(quadDir).append(BackgroundFileSystemProvider.this.strategy.getTileNameSuffix()).toString());
                if (!f.exists()) {
                    if (BackgroundFileSystemProvider.this.mode != 1 && BackgroundFileSystemProvider.this.mode != 3) {
                        BackgroundFileSystemProvider.this.tileProvider.downloadFromServer(tile, cacheURL, cancellable, drawer, prepend);
                        return;
                    }
                    BackgroundFileSystemProvider.this.context.sendMessage(callback, (IEvent)BackgroundFileSystemProvider.this.instantiateEvent(tile, ""), 1000);
                    BackgroundFileSystemProvider.this.mPending.remove(cacheURL);
                    return;
                }
                if (f.length() <= 0L || BackgroundFileSystemProvider.this.mode == 3) {
                    f.delete();
                    if (BackgroundFileSystemProvider.this.mode == 3) {
                        BackgroundFileSystemProvider.this.context.sendMessage(callback, (IEvent)BackgroundFileSystemProvider.this.instantiateEvent(tile, f.getPath()), 1003);
                        return;
                    }
                    BackgroundFileSystemProvider.this.tileProvider.downloadFromServer(tile, cacheURL, cancellable, drawer, prepend);
                    return;
                }
                if (BackgroundFileSystemProvider.this.mode == 2) {
                    BackgroundFileSystemProvider.this.tileProvider.downloadFromServer(tile, cacheURL, cancellable, drawer, prepend);
                    return;
                }
                try {
                    FileInputStream in = new FileInputStream(f);
                    while (retryCount <= TileProvider.NUM_RETRY && !succeed) {
                        block19: {
                            byte[] data;
                            block18: {
                                dataStream = new ByteArrayOutputStream();
                                out = new BufferedOutputStream(dataStream, 8192);
                                Constants.copy((InputStream)in, (OutputStream)out);
                                ((OutputStream)out).flush();
                                data = dataStream.toByteArray();
                                if (data.length <= 0) {
                                    throw new IOException("");
                                }
                                if (!cancellable.getCanceled()) break block18;
                                BackgroundFileSystemProvider.this.mPending.clear();
                                WorkQueue.getInstance().clearPendingTasks();
                                BackgroundFileSystemProvider.this.context.sendMessage(callback, (IEvent)BackgroundFileSystemProvider.this.instantiateEvent(tile, f.getPath()), -1);
                                Constants.closeStream((Closeable)in);
                                Constants.closeStream((Closeable)dataStream);
                                Constants.closeStream((Closeable)out);
                                ++retryCount;
                                return;
                            }
                            try {
                                IBitmap bmp = BackgroundFileSystemProvider.this.context.decodeByteArray(data, 0, data.length);
                                if (BackgroundFileSystemProvider.this.mCache != null) {
                                    BackgroundFileSystemProvider.this.mCache.putTile(cacheURL, bmp);
                                }
                                BackgroundFileSystemProvider.this.context.sendMessage(callback, (IEvent)BackgroundFileSystemProvider.this.instantiateEvent(tile, f.getPath()), 1000);
                                succeed = true;
                                if (drawer == null) break block19;
                                drawer.drawTile(tile.clone(), bmp);
                            }
                            catch (OutOfMemoryError ex) {
                                block20: {
                                    System.gc();
                                    BackgroundFileSystemProvider.this.mCache.onLowMemory();
                                    if (retryCount != TileProvider.NUM_RETRY) break block20;
                                    BackgroundFileSystemProvider.this.context.sendMessage(callback, (IEvent)BackgroundFileSystemProvider.this.instantiateEvent(tile, f.getPath()), 1002);
                                    {
                                        catch (Throwable throwable) {
                                            Constants.closeStream((Closeable)in);
                                            Constants.closeStream((Closeable)dataStream);
                                            Constants.closeStream(out);
                                            ++retryCount;
                                            throw throwable;
                                        }
                                    }
                                }
                                Constants.closeStream((Closeable)in);
                                Constants.closeStream((Closeable)dataStream);
                                Constants.closeStream((Closeable)out);
                                ++retryCount;
                                continue;
                                catch (Exception e) {
                                    block21: {
                                        if (retryCount != TileProvider.NUM_RETRY) break block21;
                                        BackgroundFileSystemProvider.this.context.sendMessage(callback, (IEvent)BackgroundFileSystemProvider.this.instantiateEvent(tile, f.getPath()), 1001);
                                    }
                                    Constants.closeStream((Closeable)in);
                                    Constants.closeStream((Closeable)dataStream);
                                    Constants.closeStream((Closeable)out);
                                    ++retryCount;
                                    continue;
                                }
                            }
                        }
                        Constants.closeStream((Closeable)in);
                        Constants.closeStream((Closeable)dataStream);
                        Constants.closeStream((Closeable)out);
                        ++retryCount;
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                if (BackgroundFileSystemProvider.this.mode == 1 && !succeed) {
                    BackgroundFileSystemProvider.this.mCache.putTile(cacheURL, BackgroundFileSystemProvider.this.offlineBitmap);
                    BackgroundFileSystemProvider.this.context.sendMessage(callback, (IEvent)BackgroundFileSystemProvider.this.instantiateEvent(tile, f.getPath()), 1000);
                }
                BackgroundFileSystemProvider.this.mPending.remove(cacheURL);
            }
        }, prepend);
        return true;
    }

    public synchronized void saveFile(byte[] someData, Tile tile) throws IOException {
        super.saveFile(someData, tile);
        this.mPending.remove(tile.getTileString());
    }
}

