/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.provider.filesystem.impl;

import es.prodevelop.gvsig.mini.common.IBitmap;
import es.prodevelop.gvsig.mini.common.IContext;
import es.prodevelop.gvsig.mini.common.IEvent;
import es.prodevelop.gvsig.mini.common.IHandler;
import es.prodevelop.gvsig.mini.common.impl.Tile;
import es.prodevelop.gvsig.mini.map.GeoUtils;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import es.prodevelop.gvsig.mini.utiles.Constants;
import es.prodevelop.gvsig.mini.utiles.WorkQueue;
import es.prodevelop.tilecache.draw.TileDrawer;
import es.prodevelop.tilecache.provider.Downloader;
import es.prodevelop.tilecache.provider.TileCache;
import es.prodevelop.tilecache.provider.TileProvider;
import es.prodevelop.tilecache.provider.event.TileEvent;
import es.prodevelop.tilecache.provider.filesystem.ITileFileSystemProvider;
import es.prodevelop.tilecache.provider.filesystem.strategy.ITileFileSystemStrategy;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TileFilesystemProvider
implements GeoUtils,
ITileFileSystemProvider {
    String datalog = null;
    Downloader down;
    public final TileCache mCache;
    public HashSet<String> mPending = new HashSet();
    static String SD_DIR;
    private static final Logger log;
    IContext context;
    ITileFileSystemStrategy strategy;
    int mode;
    IBitmap offlineBitmap;

    public TileFilesystemProvider(int aMaxFSCacheByteSize, TileCache aCache, IContext context, ITileFileSystemStrategy strategy, int mode, IBitmap offlineBitmap) {
        this.mCache = aCache;
        try {
            this.offlineBitmap = offlineBitmap;
            this.strategy = strategy;
            this.mode = mode;
            this.context = context;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    protected final String getSDDir() {
        try {
            SD_DIR = this.context.getExternalStorageDirectoryPath();
            return SD_DIR;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public synchronized boolean loadMapTileToMemCacheAsync(final Tile tile, final IHandler callback, final String cacheURL, final Cancellable cancellable, final TileDrawer drawer, boolean prepend) throws IOException {
        if (this.mPending.contains(cacheURL)) {
            return true;
        }
        if (this.mode == 4) {
            return false;
        }
        String quadDir = this.strategy.getRelativeToLayerDirTilePath(tile.tile, tile.zoomLevel);
        String st = this.getSDDir();
        final File f = new File(new StringBuffer().append(st).append(File.separator).append("gvSIG").append(File.separator).append("maps").append(File.separator).append(tile.layerName).append(this.strategy.getLayerNameSuffix()).append(File.separator).append(quadDir).append(this.strategy.getTileNameSuffix()).toString());
        if (!f.exists()) {
            if (this.mode == 1 || this.mode == 3) {
                this.context.sendMessage(callback, (IEvent)this.instantiateEvent(tile, ""), 1000);
                this.mPending.remove(cacheURL);
                return false;
            }
            return false;
        }
        if (f.length() <= 0L || this.mode == 3) {
            f.delete();
            if (this.mode == 3) {
                this.context.sendMessage(callback, (IEvent)this.instantiateEvent(tile, f.getPath()), 1003);
            }
            return false;
        }
        if (this.mode == 2) {
            return false;
        }
        final FileInputStream in = new FileInputStream(f);
        this.mPending.add(cacheURL);
        WorkQueue.getInstance().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                BufferedOutputStream out = null;
                ByteArrayOutputStream dataStream = null;
                boolean succeed = false;
                int retryCount = 0;
                while (retryCount <= TileProvider.NUM_RETRY && !succeed) {
                    block12: {
                        byte[] data;
                        block11: {
                            dataStream = new ByteArrayOutputStream();
                            out = new BufferedOutputStream(dataStream, 8192);
                            Constants.copy((InputStream)in, (OutputStream)out);
                            ((OutputStream)out).flush();
                            data = dataStream.toByteArray();
                            if (data.length <= 0) {
                                throw new IOException("");
                            }
                            if (!cancellable.getCanceled()) break block11;
                            TileFilesystemProvider.this.mPending.clear();
                            WorkQueue.getInstance().clearPendingTasks();
                            TileFilesystemProvider.this.context.sendMessage(callback, (IEvent)TileFilesystemProvider.this.instantiateEvent(tile, f.getPath()), -1);
                            Constants.closeStream((Closeable)in);
                            Constants.closeStream((Closeable)dataStream);
                            Constants.closeStream((Closeable)out);
                            ++retryCount;
                            return;
                        }
                        try {
                            IBitmap bmp = TileFilesystemProvider.this.context.decodeByteArray(data, 0, data.length);
                            if (TileFilesystemProvider.this.mCache != null) {
                                TileFilesystemProvider.this.mCache.putTile(cacheURL, bmp);
                            }
                            TileFilesystemProvider.this.context.sendMessage(callback, (IEvent)TileFilesystemProvider.this.instantiateEvent(tile, f.getPath()), 1000);
                            succeed = true;
                            if (drawer == null) break block12;
                            drawer.drawTile(tile.clone(), bmp);
                        }
                        catch (OutOfMemoryError ex) {
                            block13: {
                                System.gc();
                                log.log(Level.SEVERE, "OutOfMemoryError: ", ex);
                                TileFilesystemProvider.this.mCache.onLowMemory();
                                if (retryCount != TileProvider.NUM_RETRY) break block13;
                                TileFilesystemProvider.this.context.sendMessage(callback, (IEvent)TileFilesystemProvider.this.instantiateEvent(tile, f.getPath()), 1002);
                            }
                            Constants.closeStream((Closeable)in);
                            Constants.closeStream((Closeable)dataStream);
                            Constants.closeStream((Closeable)out);
                            ++retryCount;
                            continue;
                        }
                        catch (Exception e) {
                            block14: {
                                if (retryCount != TileProvider.NUM_RETRY) break block14;
                                TileFilesystemProvider.this.context.sendMessage(callback, (IEvent)TileFilesystemProvider.this.instantiateEvent(tile, f.getPath()), 1001);
                                {
                                    catch (Throwable throwable) {
                                        Constants.closeStream((Closeable)in);
                                        Constants.closeStream((Closeable)dataStream);
                                        Constants.closeStream(out);
                                        ++retryCount;
                                        throw throwable;
                                    }
                                }
                            }
                            Constants.closeStream((Closeable)in);
                            Constants.closeStream((Closeable)dataStream);
                            Constants.closeStream((Closeable)out);
                            ++retryCount;
                            continue;
                        }
                    }
                    Constants.closeStream((Closeable)in);
                    Constants.closeStream((Closeable)dataStream);
                    Constants.closeStream((Closeable)out);
                    ++retryCount;
                }
                if (TileFilesystemProvider.this.mode == 1 && !succeed) {
                    TileFilesystemProvider.this.mCache.putTile(cacheURL, TileFilesystemProvider.this.offlineBitmap);
                    TileFilesystemProvider.this.context.sendMessage(callback, (IEvent)TileFilesystemProvider.this.instantiateEvent(tile, f.getPath()), 1000);
                    TileFilesystemProvider.this.mPending.remove(cacheURL);
                }
                TileFilesystemProvider.this.mPending.remove(cacheURL);
            }
        }, prepend);
        return true;
    }

    public synchronized void saveFile(byte[] someData, Tile tile) throws IOException {
        if (this.mode == 4) {
            return;
        }
        String quadDir = this.strategy.getRelativeToLayerDirTilePath(tile.tile, tile.zoomLevel);
        String st = this.getSDDir();
        File f = new File(new StringBuffer(st).append(File.separator).append("gvSIG").append(File.separator).append("maps").append(File.separator).append(tile.layerName).append(this.strategy.getLayerNameSuffix()).append(File.separator).append(quadDir).append(this.strategy.getTileNameSuffix()).toString());
        if (f.exists()) {
            if (f.length() <= 0L) {
                f.delete();
                f.createNewFile();
            }
        } else {
            File dir = new File(f.getParent());
            if (dir.mkdirs() || f.getParent() == null) {
                // empty if block
            }
        }
        FileOutputStream fos = new FileOutputStream(f);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 8192);
        try {
            bos.write(someData);
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "save file", e);
        }
        Constants.closeStream((Closeable)fos);
        Constants.closeStream((Closeable)bos);
    }

    public void destroy() {
    }

    public ITileFileSystemStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ITileFileSystemStrategy strategy) {
        this.strategy = strategy;
    }

    public TileCache getTileCache() {
        return this.mCache;
    }

    public Set getPendingQueue() {
        return this.mPending;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    protected TileEvent instantiateEvent(Tile aTile, String path) {
        return new TileEvent(aTile.clone(), path, this.getMode(), this.getStrategy().getName(), 1);
    }

    static {
        log = Logger.getLogger("TileFilesystemProvider");
    }
}

