/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.renderer;

import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.Pixel;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.gvsig.mini.projection.TileConversor;
import es.prodevelop.gvsig.mobile.fmap.proj.Projection;
import es.prodevelop.tilecache.renderer.OSMMercatorRenderer;

public class EquatorRenderer
extends OSMMercatorRenderer {
    String firstPart = "";
    String xParm = "";
    String yParm = "";
    String zParm = "";

    private EquatorRenderer(String[] aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        super(aBaseUrl, aName, aImageFilenameEnding, aZoomMax, aZoomMin, aTileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
    }

    public static EquatorRenderer getEquatorRenderer(String[] aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        EquatorRenderer r = new EquatorRenderer(aBaseUrl, aName, aImageFilenameEnding, aZoomMax, aZoomMin, aTileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
        return r;
    }

    public String getTileURLString(int[] tileID, int zoomLevel) {
        try {
            int ytile = (1 << zoomLevel >> 1) - 1 - tileID[0];
            String baseURL = this.getBASEURL();
            if (this.firstPart.compareTo("") == 0 || this.xParm.compareTo("") == 0 || this.yParm.compareTo("") == 0 || this.zParm.compareTo("") == 0) {
                this.firstPart = baseURL.substring(0, baseURL.indexOf("#"));
                String secondPart = baseURL.substring(baseURL.indexOf("#") + 1, baseURL.length());
                this.xParm = secondPart.substring(0, secondPart.indexOf("#"));
                secondPart = secondPart.substring(secondPart.indexOf("#") + 1, secondPart.length());
                this.yParm = secondPart.substring(secondPart.indexOf("#") + 1, secondPart.indexOf("#", 1));
                secondPart = secondPart.substring(secondPart.indexOf("#", 1) + 1, secondPart.length());
                this.zParm = secondPart.substring(secondPart.indexOf("#") + 1, secondPart.indexOf("#", 1));
            }
            this.firstPart = baseURL.substring(0, baseURL.indexOf("#"));
            return this.firstPart + this.xParm + tileID[1] + this.yParm + ytile + this.zParm + (17 - zoomLevel + 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Extent getExtentIncludingCenter(Point center, int zoomLevel, Point origin) {
        Extent ex = null;
        Pixel tileNumber = null;
        Object profile = null;
        try {
            Point p = TileConversor.mercatorToLatLon((double)center.getX(), (double)center.getY());
            tileNumber = TileConversor.getTileNumber((double)p.getX(), (double)p.getY(), (int)zoomLevel);
            ex = TileConversor.tileOSMMercatorBounds((int)tileNumber.getX(), (int)tileNumber.getY(), (int)zoomLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ex;
    }

    public String buildQuery(Extent e, int zoomLevel, double resolution) {
        Point center = e.getCenter();
        int zoomYahoo = 17 - zoomLevel + 1;
        Pixel tileN = this.getTileNumber(e, zoomLevel, resolution, null);
        StringBuffer query = new StringBuffer().append(this.getURL()).append("&x=").append(tileN.getX()).append("&y=").append(tileN.getY()).append("&z=").append(zoomYahoo).append(".jpg");
        return query.toString();
    }

    public StringBuffer getQuadkey(int tileX, int tileY, int zoomLevel) {
        try {
            if (tileX == -1) {
                return null;
            }
            return TileConversor.tileXYToQuadKey((int)tileX, (int)tileY, (int)zoomLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pixel getTileNumber(Extent e, int zoomLevel, double resolution, Projection proj) {
        Point p = TileConversor.mercatorToLatLon((double)e.getCenter().getX(), (double)e.getCenter().getY());
        return TileConversor.getYahooTileNumber((double)p.getX(), (double)p.getY(), (int)zoomLevel);
    }
}

