/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.renderer;

import es.prodevelop.geodetic.utils.conversion.ConversionCoords;
import es.prodevelop.gvsig.mini.common.IBitmap;
import es.prodevelop.gvsig.mini.common.ICanvas;
import es.prodevelop.gvsig.mini.common.impl.Tile;
import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.IGeometry;
import es.prodevelop.gvsig.mini.geom.Pixel;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.gvsig.mini.map.GeoMath;
import es.prodevelop.gvsig.mini.map.ViewPort;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import es.prodevelop.gvsig.mobile.fmap.proj.CRSFactory;
import es.prodevelop.gvsig.mobile.fmap.proj.Projection;
import es.prodevelop.tilecache.WMSHandler;
import es.prodevelop.tilecache.provider.TileProvider;

public abstract class MapRenderer
extends WMSHandler {
    private int zoomLevel = 0;
    private Extent offlineExtent = null;
    private String offlineLayerName = "";
    public static final String NAME_SEPARATOR = ">";
    public static final String URL_SEPARATOR = ">";
    private String NAME;
    private String IMAGE_FILENAMEENDING;
    private int ZOOM_MAXLEVEL;
    private int MAPTILE_SIZEPX;
    private int zoomMinLevel;
    protected String SRS = "EPSG:4326";
    private static final String DEFAULT_SRS = "EPSG:4326";
    public static final double[] MERCATOR_RESOLUTIONS = new double[]{156543.03392804097, 78271.51696402048, 39135.75848201024, 19567.87924100512, 9783.93962050256, 4891.96981025128, 2445.98490512564, 1222.99245256282, 611.49622628141, 305.748113140705, 152.8740565703525, 76.43702828517625, 38.21851414258813, 19.109257071294063, 9.554628535647032, 4.777314267823516, 2.388657133911758, 1.194328566955879, 0.5971642834779395, 0.29858214173896974, 0.14929107086948487, 0.07464553543474244, 0.03732276771737122, 0.01866138385868561, 0.009330691929342804};
    public double[] resolutions = new double[]{1.40625, 0.703125, 0.3515625, 0.17578125, 0.087890625, 0.0439453125, 0.02197265625, 0.010986328125, 0.0054931640625, 0.00274658203125, 0.001373291015625, 6.866455078125E-4, 3.4332275390625E-4, 1.71661376953125E-4, 8.58306884765625E-5, 4.291534423828125E-5, 2.1457672119140625E-5, 1.0728836059570312E-5, 5.364418029785156E-6, 2.682209014892578E-6, 1.341104507446289E-6, 6.705522537231445E-7, 3.3527612686157227E-7};
    public static final int TMS_RENDERER = 3;
    public static final int OSM_ZYX_RENDERER = 7;
    public static final int QRST_RENDERER = 8;
    public static final int OSM_RENDERER = 0;
    public static final int EQUATOR_RENDERER = 1;
    public static final int QUADKEY_RENDERER = 2;
    public static final int OSMPARMS_RENDERER = 4;
    public static final int WMS_RENDERER = 5;
    public static final int OS_RENDERER = 6;
    public Point center = new Point(0.0, 0.0);
    private Extent extent;
    private double originX = 0.0;
    private double originY = 0.0;
    private Point latLonCenter = new Point(0.0, 0.0);
    private int type = 0;

    public MapRenderer(String[] aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        this.setURL(aBaseUrl);
        this.setNAME(aName.replaceAll(":", "_"));
        this.setZOOM_MAXLEVEL(aZoomMax);
        this.setIMAGE_FILENAMEENDING(aImageFilenameEnding);
        this.setMAPTILE_SIZEPX(aTileSizePX);
        this.setZoomMinLevel(aZoomMin);
        this.setSRS(SRS);
        this.resolutions = resolutions;
        this.extent = maxExtent;
        if (origin != null) {
            this.originX = origin.getX();
            this.originY = origin.getY();
        }
        this.type = type;
        this.offlineExtent = offExtent;
    }

    public abstract String getTileURLString(int[] var1, int var2);

    public Extent getExtent() {
        return this.extent;
    }

    public double getOriginX() {
        return this.originX;
    }

    public double getOriginY() {
        return this.originY;
    }

    public String getBASEURL() {
        return this.getURL();
    }

    public String getNAME() {
        int index;
        if (this.isOffline() && (index = this.NAME.indexOf(">")) != -1) {
            return this.NAME.substring(0, index);
        }
        return this.NAME;
    }

    public String getFullNAME() {
        return this.NAME;
    }

    public String getIMAGE_FILENAMEENDING() {
        return this.IMAGE_FILENAMEENDING;
    }

    public int getZOOM_MAXLEVEL() {
        return this.ZOOM_MAXLEVEL;
    }

    public int getMAPTILE_SIZEPX() {
        return this.MAPTILE_SIZEPX;
    }

    public void setNAME(String value) {
        this.NAME = value.replaceAll(":", "_");
    }

    public void setIMAGE_FILENAMEENDING(String value) {
        this.IMAGE_FILENAMEENDING = value;
    }

    public void setZOOM_MAXLEVEL(int value) {
        this.ZOOM_MAXLEVEL = value;
    }

    public void setMAPTILE_SIZEPX(int value) {
        this.MAPTILE_SIZEPX = value;
    }

    public int getType() {
        return this.type;
    }

    public abstract int isTMS();

    public abstract String toString();

    public String getSRS() {
        return this.SRS;
    }

    public void setSRS(String srs) {
        this.SRS = srs;
    }

    public abstract double[] transformCenter(String var1);

    public abstract void setCenter(double var1, double var3);

    public abstract Point getCenter();

    public abstract Pixel getCenterE6();

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = Math.min(zoomLevel, this.getZOOM_MAXLEVEL());
    }

    public abstract Pixel getUpperLeftCornerOfCenterMapTileInScreen(Pixel var1);

    public abstract int[] getMapTileFromCenter();

    public abstract double[] fromPixels(int[] var1);

    public abstract int[] toPixels(double[] var1);

    public abstract int[] toPixelsFromLonLat(double[] var1);

    public abstract void centerOnBBox();

    public void reprojectGeometryCoordinates(IGeometry geometry, String fromCRS) {
        try {
            Point[] points = geometry.getCoordinates();
            int size = points.length;
            Point temp = null;
            for (int i = 0; i < size; ++i) {
                temp = points[i];
                if (temp == null) continue;
                double[] coords = ConversionCoords.reproject((double)temp.getX(), (double)temp.getY(), (Projection)CRSFactory.getCRS((String)fromCRS), (Projection)CRSFactory.getCRS((String)this.getSRS()));
                temp.setX(coords[0]);
                temp.setY(coords[1]);
                points[i] = temp;
            }
            geometry.setCoordinates(points);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getURLs() {
        return this.geturls();
    }

    public String getURLtoString() {
        int size = this.getURLs().length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            result.append(this.getURLs()[i]);
            if (i == size - 1) continue;
            result.append(">");
        }
        return result.toString();
    }

    public void setZoomMinLevel(int zoomMinLevel) {
        this.zoomMinLevel = zoomMinLevel;
    }

    public int getZoomMinLevel() {
        return this.zoomMinLevel;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
        this.setOriginX(extent.getMinX());
        this.setOriginY(extent.getMinY());
    }

    public void setOriginX(double originX) {
        this.originX = originX;
    }

    public void setOriginY(double originY) {
        this.originY = originY;
    }

    public boolean allowsMassiveDownload() {
        return false;
    }

    public abstract Extent getTileExtent(int var1, int var2, double var3, double var5, double var7);

    public boolean isOffline() {
        return this.offlineExtent != null;
    }

    public Extent getOfflineExtent() {
        return this.offlineExtent;
    }

    public void setOfflineExtent(Extent offlineExtent) {
        this.offlineExtent = offlineExtent;
    }

    public String getOfflineLayerName() {
        return this.offlineLayerName;
    }

    public void setOfflineLayerName(String offlineLayerName) {
        this.offlineLayerName = offlineLayerName;
    }

    public void setLatLonCenter(Point latLonCenter) {
        this.latLonCenter = latLonCenter;
    }

    public Point getLatLonCenter() {
        return this.latLonCenter;
    }

    public abstract Extent getCurrentExtent();

    public abstract double getCurrentRes();

    public void onDraw(ICanvas c, int width, int height, TileProvider tileProvider, Cancellable cancellable) {
        try {
            ViewPort.mapHeight = width;
            ViewPort.mapWidth = height;
            int zoomLevel = this.getZoomLevel();
            int tileSizePx = this.getMAPTILE_SIZEPX();
            int[] centerMapTileCoords = this.getMapTileFromCenter();
            Pixel upperLeftCornerOfCenterMapTile = this.getUpperLeftCornerOfCenterMapTileInScreen(null);
            int centerMapTileScreenLeft = upperLeftCornerOfCenterMapTile.getX();
            int centerMapTileScreenTop = upperLeftCornerOfCenterMapTile.getY();
            int centerMapTileScreenRight = centerMapTileScreenLeft + tileSizePx;
            int centerMapTileScreenBottom = centerMapTileScreenTop + tileSizePx;
            int additionalTilesNeededToLeftOfCenter = (int)Math.ceil((float)centerMapTileScreenLeft / (float)tileSizePx);
            int additionalTilesNeededToRightOfCenter = (int)Math.ceil((float)(width - centerMapTileScreenRight) / (float)tileSizePx);
            int additionalTilesNeededToTopOfCenter = (int)Math.ceil((float)centerMapTileScreenTop / (float)tileSizePx);
            int additionalTilesNeededToBottomOfCenter = (int)Math.ceil((float)(height - centerMapTileScreenBottom) / (float)tileSizePx);
            int mapTileUpperBound = (int)Math.pow(2.0, zoomLevel + 1) + 1;
            int[] mapTileCoords = new int[]{centerMapTileCoords[1], centerMapTileCoords[0]};
            int size = (additionalTilesNeededToBottomOfCenter + additionalTilesNeededToTopOfCenter + 1) * (additionalTilesNeededToRightOfCenter + additionalTilesNeededToLeftOfCenter + 1);
            Tile[] tiles = new Tile[size];
            int cont = 0;
            Extent maxExtent = this.getExtent();
            Extent viewExtent = ViewPort.calculateExtent((Point)this.getCenter(), (double)this.resolutions[zoomLevel], (double)width, (double)height);
            boolean process = true;
            for (int y = -additionalTilesNeededToTopOfCenter; y <= additionalTilesNeededToBottomOfCenter; ++y) {
                for (int x = -additionalTilesNeededToLeftOfCenter; x <= additionalTilesNeededToRightOfCenter; ++x) {
                    process = true;
                    if (process) {
                        mapTileCoords[0] = GeoMath.mod((int)(centerMapTileCoords[0] + this.isTMS() * y), (int)mapTileUpperBound);
                        mapTileCoords[1] = GeoMath.mod((int)(centerMapTileCoords[1] + x), (int)mapTileUpperBound);
                        String tileURLString = this.getTileURLString(mapTileCoords, zoomLevel);
                        int[] tile = new int[]{mapTileCoords[0], mapTileCoords[1]};
                        int tileLeft = ViewPort.mTouchMapOffsetX + centerMapTileScreenLeft + x * tileSizePx;
                        int tileTop = ViewPort.mTouchMapOffsetY + centerMapTileScreenTop + y * tileSizePx;
                        Tile t = new Tile(tileURLString, tile, new Pixel(tileLeft, tileTop), zoomLevel, this.getNAME(), cancellable, null);
                        if (cont < tiles.length) {
                            tiles[cont] = t;
                        }
                    }
                    ++cont;
                }
            }
            for (Tile temp : tiles) {
                if (temp == null) continue;
                try {
                    IBitmap currentMapTile = tileProvider.getMapTile(temp, cancellable, null);
                    if (currentMapTile == null || currentMapTile.getBitmap() == null) continue;
                    c.drawBitmap(currentMapTile, (float)temp.distanceFromCenter.getX(), (float)temp.distanceFromCenter.getY(), null);
                    temp.destroy();
                    temp = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            tiles = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

