/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.renderer;

import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.tilecache.renderer.EquatorRenderer;
import es.prodevelop.tilecache.renderer.IMapRendererFactory;
import es.prodevelop.tilecache.renderer.MapRenderer;
import es.prodevelop.tilecache.renderer.OSMMercatorRenderer;
import es.prodevelop.tilecache.renderer.OSMParmsRenderer;
import es.prodevelop.tilecache.renderer.OSMZYXRenderer;
import es.prodevelop.tilecache.renderer.QRSTRenderer;
import es.prodevelop.tilecache.renderer.QuadkeyRenderer;
import es.prodevelop.tilecache.renderer.TMSRenderer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapRendererFactory
implements IMapRendererFactory {
    private static final Logger logger = Logger.getLogger("MapRendererFactory");

    public MapRenderer getMapRenderer(String layerTitle, String[] layerProps) {
        MapRenderer renderer = null;
        try {
            int index = layerProps[0].indexOf("[");
            Extent offExtent = null;
            String offlineLayerName = "";
            if (index != -1) {
                try {
                    String ex = layerProps[0].substring(index + 1, layerProps[0].length() - 1);
                    if (ex != null && ex.compareTo("") != 0) {
                        String[] parts = ex.split(">");
                        offExtent = Extent.parseString((String)parts[0], (String)":");
                        offlineLayerName = parts[1];
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int type = Integer.valueOf(layerProps[0].substring(0, 1));
            String[] url = layerProps[1].split(">");
            String format = layerProps[2];
            int minZoomLevel = Integer.valueOf(layerProps[4]);
            int maxZoomLevel = Integer.valueOf(layerProps[3]);
            int tileSize = Integer.valueOf(layerProps[5]);
            double minX = Double.valueOf(layerProps[8]);
            double minY = Double.valueOf(layerProps[9]);
            double maxX = Double.valueOf(layerProps[10]);
            double maxY = Double.valueOf(layerProps[11]);
            double originX = Double.valueOf(layerProps[6]);
            double originY = Double.valueOf(layerProps[7]);
            String SRS = layerProps[12];
            String[] resol = layerProps[13].split(":");
            int length = resol.length;
            double[] resolutions = new double[length];
            for (int i = 0; i < length; ++i) {
                resolutions[i] = Double.valueOf(resol[i]);
            }
            switch (type) {
                case 1: {
                    logger.log(Level.FINE, "EQUATOR_RENDERER " + layerTitle);
                    renderer = EquatorRenderer.getEquatorRenderer(url, layerTitle, format, maxZoomLevel, minZoomLevel, tileSize, type, new Point(originX, originY), new Extent(minX, minY, maxX, maxY), SRS, resolutions, offExtent);
                    break;
                }
                case 0: {
                    logger.log(Level.FINE, "OSM_RENDERER " + layerTitle);
                    renderer = OSMMercatorRenderer.getOSMMercatorRenderer(url, layerTitle, format, maxZoomLevel, minZoomLevel, tileSize, type, new Point(originX, originY), new Extent(minX, minY, maxX, maxY), SRS, resolutions, offExtent);
                    break;
                }
                case 7: {
                    logger.log(Level.FINE, "OSM_ZXY_RENDERER " + layerTitle);
                    renderer = OSMZYXRenderer.getOSMZYXRenderer(url, layerTitle, format, maxZoomLevel, minZoomLevel, tileSize, type, new Point(originX, originY), new Extent(minX, minY, maxX, maxY), SRS, resolutions, offExtent);
                    break;
                }
                case 4: {
                    logger.log(Level.FINE, "OSMPARMS_RENDERER " + layerTitle);
                    renderer = OSMParmsRenderer.getOSMParmsRenderer(url, layerTitle, format, maxZoomLevel, minZoomLevel, tileSize, type, new Point(originX, originY), new Extent(minX, minY, maxX, maxY), SRS, resolutions, offExtent);
                    break;
                }
                case 2: {
                    logger.log(Level.FINE, "QUADKEY_RENDERER " + layerTitle);
                    renderer = QuadkeyRenderer.getQuadkeyRenderer(url, layerTitle, format, maxZoomLevel, minZoomLevel, tileSize, type, new Point(originX, originY), new Extent(minX, minY, maxX, maxY), SRS, resolutions, offExtent);
                    break;
                }
                case 8: {
                    logger.log(Level.FINE, "QRST_RENDERER " + layerTitle);
                    renderer = QRSTRenderer.getQRSTRenderer(url, layerTitle, format, maxZoomLevel, minZoomLevel, tileSize, type, new Point(originX, originY), new Extent(minX, minY, maxX, maxY), SRS, resolutions, offExtent);
                    break;
                }
                case 3: {
                    logger.log(Level.FINE, "Found a TMS layer" + layerTitle);
                    renderer = TMSRenderer.getTMSRenderer(layerProps, layerTitle);
                    break;
                }
                case 5: {
                    logger.log(Level.FINE, "Found a WMS layer: " + layerTitle);
                }
            }
            if (renderer != null && offlineLayerName != null) {
                renderer.setOfflineLayerName(offlineLayerName);
            }
            return renderer;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getMapRenderer: ", e);
            return renderer;
        }
    }
}

