/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.renderer;

import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.Pixel;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.gvsig.mini.map.ViewPort;
import es.prodevelop.gvsig.mini.projection.TileConversor;
import es.prodevelop.gvsig.mobile.fmap.proj.Projection;
import es.prodevelop.tilecache.renderer.MapRenderer;
import es.prodevelop.tilecache.renderer.TMSRenderer;

public class OSMMercatorRenderer
extends TMSRenderer {
    OSMMercatorRenderer(String[] baseUrl, String name, String imageFilenameEnding, int zoomMax, int zoomMin, int tileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        super(baseUrl, name, imageFilenameEnding, zoomMax, zoomMin, tileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
    }

    public static OSMMercatorRenderer getOSMMercatorRenderer(String[] aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        OSMMercatorRenderer r = new OSMMercatorRenderer(aBaseUrl, aName, aImageFilenameEnding, aZoomMax, aZoomMin, aTileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
        return r;
    }

    public static OSMMercatorRenderer getMapnikRenderer() {
        return OSMMercatorRenderer.getOSMMercatorRenderer(new String[]{"http://a.tile.openstreetmap.org/", "http://b.tile.openstreetmap.org/", "http://c.tile.openstreetmap.org/"}, "OPEN STREET MAP", "png", 18, 0, 256, 0, new Point(-2.0037508342789244E7, -2.0037508342789244E7), new Extent(-2.0037508342789244E7, -2.0037508342789244E7, 2.0037508342789244E7, 2.0037508342789244E7), "EPSG:900913", MapRenderer.MERCATOR_RESOLUTIONS, null);
    }

    public static OSMMercatorRenderer getOsmarenderRenderer() {
        return OSMMercatorRenderer.getOSMMercatorRenderer(new String[]{"http://tah.openstreetmap.org/Tiles/tile/"}, "OSMARENDER", "png", 18, 0, 256, 0, new Point(-2.0037508342789244E7, -2.0037508342789244E7), new Extent(-2.0037508342789244E7, -2.0037508342789244E7, 2.0037508342789244E7, 2.0037508342789244E7), "EPSG:900913", MapRenderer.MERCATOR_RESOLUTIONS, null);
    }

    public static OSMMercatorRenderer getCloudmadeRenderer() {
        return OSMMercatorRenderer.getOSMMercatorRenderer(new String[]{"http://b.tile.cloudmade.com/BC9A493B41014CAABB98F0471D759707/1/256/", "http://a.tile.cloudmade.com/BC9A493B41014CAABB98F0471D759707/1/256/", "http://c.tile.cloudmade.com/BC9A493B41014CAABB98F0471D759707/1/256/"}, "CLOUDMADE", "png", 18, 0, 256, 0, new Point(-2.0037508342789244E7, -2.0037508342789244E7), new Extent(-2.0037508342789244E7, -2.0037508342789244E7, 2.0037508342789244E7, 2.0037508342789244E7), "EPSG:900913", MapRenderer.MERCATOR_RESOLUTIONS, null);
    }

    public static OSMMercatorRenderer getCycleMapRenderer() {
        return OSMMercatorRenderer.getOSMMercatorRenderer(new String[]{"http://andy.sandbox.cloudmade.com/tiles/cycle/"}, "CYCLE MAP", "jpg", 18, 0, 256, 0, new Point(-2.0037508342789244E7, -2.0037508342789244E7), new Extent(-2.0037508342789244E7, -2.0037508342789244E7, 2.0037508342789244E7, 2.0037508342789244E7), "EPSG:900913", MapRenderer.MERCATOR_RESOLUTIONS, null);
    }

    public int isTMS() {
        return 1;
    }

    public String getSRS() {
        return "EPSG:3785";
    }

    public Pixel getUpperLeftCornerOfCenterMapTileInScreen(Pixel reuse) {
        Pixel out = reuse != null ? reuse : new Pixel(0, 0);
        Point center = TileConversor.mercatorToLatLon((double)this.getCenter().getX(), (double)this.getCenter().getY());
        Pixel tile = TileConversor.getTileNumber((double)center.getX(), (double)center.getY(), (int)this.getZoomLevel());
        Extent e1 = TileConversor.tileOSMMercatorBounds((int)tile.getX(), (int)tile.getY(), (int)this.getZoomLevel());
        Extent e2 = ViewPort.calculateExtent((Point)new Point(this.getCenter().getX(), this.getCenter().getY()), (double)this.getResolutions()[this.getZoomLevel()], (double)ViewPort.mapWidth, (double)ViewPort.mapHeight);
        int[] centerTopLeft = ViewPort.fromMapPoint((double[])new double[]{e1.getMinX(), e1.getMaxY()}, (double)e2.getMinX(), (double)e2.getMaxY(), (double)this.getResolutions()[this.getZoomLevel()]);
        out.setX(centerTopLeft[0]);
        out.setY(centerTopLeft[1]);
        return out;
    }

    public int[] getMapTileFromCenter() {
        Point center = TileConversor.mercatorToLatLon((double)this.getCenter().getX(), (double)this.getCenter().getY());
        Pixel tile = TileConversor.getTileNumber((double)center.getX(), (double)center.getY(), (int)this.getZoomLevel());
        return new int[]{tile.getY(), tile.getX()};
    }

    public String getTileURLString(int[] tileID, int zoomLevel) {
        return this.getBASEURL() + zoomLevel + "/" + tileID[1] + "/" + tileID[0] + "." + this.getIMAGE_FILENAMEENDING();
    }

    public String buildQuery(Extent e, int zoomLevel, double resolution) {
        Point center = e.getCenter();
        Pixel tileN = this.getTileNumber(e, zoomLevel, resolution, null);
        StringBuffer query = new StringBuffer().append(this.getURL()).append("/").append(zoomLevel).append("/").append(tileN.getX()).append("/").append(tileN.getY()).append(".png");
        return query.toString();
    }

    public StringBuffer getQuadkey(int tileX, int tileY, int zoomLevel) {
        try {
            if (tileX == -1) {
                return null;
            }
            return TileConversor.tileXYToQuadKey((int)tileX, (int)tileY, (int)zoomLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pixel getTileNumber(Extent e, int zoomLevel, double resolution, Projection proj) {
        Point p = TileConversor.mercatorToLatLon((double)e.getCenter().getX(), (double)e.getCenter().getY());
        return TileConversor.getTileNumber((double)p.getX(), (double)p.getY(), (int)zoomLevel);
    }

    public Extent getExtentIncludingCenter(Point center, int zoomLevel, Point origin) {
        Extent ex = null;
        Pixel tileNumber = null;
        Object profile = null;
        try {
            Point p = null;
            p = TileConversor.mercatorToLatLon((double)center.getX(), (double)center.getY());
            tileNumber = TileConversor.getTileNumber((double)p.getX(), (double)p.getY(), (int)zoomLevel);
            ex = TileConversor.tileOSMMercatorBounds((int)tileNumber.getX(), (int)tileNumber.getY(), (int)zoomLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ex;
    }

    public Extent getTileExtent(int tileX, int tileY, double resolution, double originX, double originY) {
        int length = this.resolutions.length;
        int zoomLevel = 0;
        for (int i = 0; i < length; ++i) {
            if (this.resolutions[i] != resolution) continue;
            zoomLevel = i;
            break;
        }
        Extent e1 = TileConversor.tileOSMMercatorBounds((int)tileX, (int)tileY, (int)zoomLevel);
        return e1;
    }

    public boolean allowsMassiveDownload() {
        try {
            String name = this.getBASEURL();
            return name.contains("openstreetmap") || name.contains("cloudmade");
        }
        catch (Exception e) {
            return false;
        }
    }
}

