/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.renderer;

import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.Pixel;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.gvsig.mini.projection.TileConversor;
import es.prodevelop.gvsig.mobile.fmap.proj.Projection;
import es.prodevelop.tilecache.renderer.OSMMercatorRenderer;

public class QuadkeyRenderer
extends OSMMercatorRenderer {
    String firstPart = "";
    String secondPart = "";

    QuadkeyRenderer(String[] aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        super(aBaseUrl, aName, aImageFilenameEnding, aZoomMax, aZoomMin, aTileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
    }

    public static QuadkeyRenderer getQuadkeyRenderer(String[] aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        QuadkeyRenderer r = new QuadkeyRenderer(aBaseUrl, aName, aImageFilenameEnding, aZoomMax, aZoomMin, aTileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
        return r;
    }

    public String getTileURLString(int[] tileID, int zoomLevel) {
        try {
            String quad = TileConversor.tileXYToQuadKey((int)tileID[1], (int)tileID[0], (int)zoomLevel).toString();
            String baseURL = this.getBASEURL();
            if (this.firstPart.compareTo("") == 0 || this.secondPart.compareTo("") == 0) {
                this.firstPart = baseURL.substring(0, baseURL.indexOf("#"));
                this.secondPart = baseURL.substring(baseURL.lastIndexOf("#") + 1, baseURL.length());
            }
            this.firstPart = baseURL.substring(0, baseURL.indexOf("#"));
            return this.firstPart + quad + this.secondPart;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Extent getExtentIncludingCenter(Point center, int zoomLevel, Point origin) {
        Extent ex = null;
        Pixel tileNumber = null;
        Object profile = null;
        try {
            Point p = null;
            p = TileConversor.mercatorToLatLon((double)center.getX(), (double)center.getY());
            tileNumber = TileConversor.getTileNumber((double)p.getX(), (double)p.getY(), (int)zoomLevel);
            ex = TileConversor.tileOSMMercatorBounds((int)tileNumber.getX(), (int)tileNumber.getY(), (int)zoomLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ex;
    }

    public String buildQuery(Extent e, int zoomLevel, double resolution) {
        Pixel tileN = this.getTileNumber(e, zoomLevel, resolution, null);
        String quad = TileConversor.tileXYToQuadKey((int)tileN.getX(), (int)tileN.getY(), (int)zoomLevel).toString();
        return this.getURL() + quad + ".jpeg?g=174";
    }

    public StringBuffer getQuadkey(int tileX, int tileY, int zoomLevel) {
        try {
            if (tileX == -1) {
                return null;
            }
            return TileConversor.tileXYToQuadKey((int)tileX, (int)tileY, (int)zoomLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pixel getTileNumber(Extent e, int zoomLevel, double resolution, Projection proj) {
        Point p = TileConversor.mercatorToLatLon((double)e.getCenter().getX(), (double)e.getCenter().getY());
        return TileConversor.getTileNumber((double)p.getX(), (double)p.getY(), (int)zoomLevel);
    }
}

