/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.renderer;

import es.prodevelop.geodetic.utils.conversion.ConversionCoords;
import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.Pixel;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.gvsig.mini.map.ViewPort;
import es.prodevelop.gvsig.mini.projection.TileConversor;
import es.prodevelop.gvsig.mobile.fmap.proj.CRSFactory;
import es.prodevelop.gvsig.mobile.fmap.proj.Projection;
import es.prodevelop.tilecache.renderer.MapRenderer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.util.ByteArrayBuffer;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TMSRenderer
extends MapRenderer {
    private static final Logger logger = Logger.getLogger("TMSRenderer");
    Vector tempRes = new Vector();
    static String encoding = "UTF-8";
    private Extent currentExtent;
    private double currentRes;

    protected TMSRenderer(String[] aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        super(aBaseUrl, aName, aImageFilenameEnding, aZoomMax, aZoomMin, aTileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
    }

    public static TMSRenderer getTMSRenderer(String url, String layerName) {
        TMSRenderer t = TMSRenderer.getTMSRenderer(url, layerName, null, 1, 0, 256, 3, null, null, null, null, null);
        t.tryParseTileSet(url);
        return t;
    }

    public static TMSRenderer loadProperties(String[] props, String layerName) {
        try {
            int index = props[0].indexOf("[");
            Extent offExtent = null;
            String offlineLayerName = "";
            if (index != -1) {
                try {
                    String ex = props[0].substring(index + 1, props[0].length() - 1);
                    if (ex != null && ex.compareTo("") != 0) {
                        String[] parts = ex.split(">");
                        offExtent = Extent.parseString((String)parts[0], (String)":");
                        offlineLayerName = parts[1];
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int type = Integer.valueOf(props[0].substring(0, 1));
            String[] url = props[1].split(">");
            String format = props[2];
            int minZoomLevel = Integer.valueOf(props[4]);
            int maxZoomLevel = Integer.valueOf(props[3]);
            int tileSize = Integer.valueOf(props[5]);
            double minX = Double.valueOf(props[8]);
            double minY = Double.valueOf(props[9]);
            double maxX = Double.valueOf(props[10]);
            double maxY = Double.valueOf(props[11]);
            double originX = Double.valueOf(props[6]);
            double originY = Double.valueOf(props[7]);
            String SRS = props[12];
            String[] resol = props[13].split(":");
            int length = resol.length;
            double[] resolutions = new double[length];
            for (int i = 0; i < length; ++i) {
                try {
                    resolutions[i] = Double.valueOf(resol[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            TMSRenderer renderer = new TMSRenderer(url, layerName, format, maxZoomLevel, minZoomLevel, tileSize, type, new Point(originX, originY), new Extent(minX, minY, maxX, maxY), SRS, resolutions, offExtent);
            return renderer;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getTMSRenderer: ", e);
            return null;
        }
    }

    public static TMSRenderer getTMSRenderer(String[] props, String layerName) {
        try {
            if (props.length == 2) {
                return TMSRenderer.getTMSRenderer(props[1], layerName);
            }
            return TMSRenderer.loadProperties(props, layerName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getTMSRenderer: ", e);
            return null;
        }
    }

    public static TMSRenderer getTMSRenderer(String aBaseUrl, String aName, String aImageFilenameEnding, int aZoomMax, int aZoomMin, int aTileSizePX, int type, Point origin, Extent maxExtent, String SRS, double[] resolutions, Extent offExtent) {
        TMSRenderer r = new TMSRenderer(new String[]{aBaseUrl}, aName, aImageFilenameEnding, aZoomMax, aZoomMin, aTileSizePX, type, origin, maxExtent, SRS, resolutions, offExtent);
        return r;
    }

    public String getTileURLString(int[] tileID, int zoomLevel) {
        String s = this.getBASEURL() + zoomLevel + "/" + tileID[1] + "/" + tileID[0] + "." + this.getIMAGE_FILENAMEENDING();
        return s;
    }

    public double[] getResolutions() {
        return this.resolutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void tryParseTileSet(String url) {
        block63: {
            ByteArrayBuffer baf;
            BufferedInputStream bis;
            InputStream is;
            block58: {
                int length2222;
                URL parseURL = null;
                URLConnection urlconnec = null;
                is = null;
                bis = null;
                baf = null;
                try {
                    block57: {
                        parseURL = new URL(url);
                        urlconnec = parseURL.openConnection();
                        is = urlconnec.getInputStream();
                        bis = new BufferedInputStream(is);
                        baf = new ByteArrayBuffer(50);
                        int current = 0;
                        while ((current = bis.read()) != -1) {
                            baf.append((int)((byte)current));
                        }
                        KXmlParser kxmlParser = TMSRenderer.createParser(baf.toByteArray());
                        kxmlParser.nextTag();
                        if (kxmlParser.getEventType() == 1) break block57;
                        kxmlParser.require(2, null, "TileMap");
                        int tag = kxmlParser.nextTag();
                        while (tag != 1) {
                            switch (tag) {
                                case 2: {
                                    if (kxmlParser.getName().compareTo("SRS") == 0) {
                                        kxmlParser.next();
                                        this.SRS = kxmlParser.getText();
                                        break;
                                    }
                                    if (kxmlParser.getName().compareTo("BoundingBox") == 0) {
                                        double minx = 0.0;
                                        double maxx = 0.0;
                                        double miny = 0.0;
                                        double maxy = 0.0;
                                        String value = "";
                                        try {
                                            value = kxmlParser.getAttributeValue("", "minx");
                                            if (value != null) {
                                                minx = Double.parseDouble(value);
                                            }
                                            if ((value = kxmlParser.getAttributeValue("", "maxx")) != null) {
                                                maxx = Double.parseDouble(value);
                                            }
                                            if ((value = kxmlParser.getAttributeValue("", "miny")) != null) {
                                                miny = Double.parseDouble(value);
                                            }
                                            if ((value = kxmlParser.getAttributeValue("", "maxy")) != null) {
                                                maxy = Double.parseDouble(value);
                                            }
                                            this.setExtent(new Extent(minx, miny, maxx, maxy));
                                        }
                                        catch (Exception ex) {
                                            logger.log(Level.SEVERE, "", ex);
                                        }
                                        break;
                                    }
                                    if (kxmlParser.getName().compareTo("Origin") == 0) {
                                        double x = 0.0;
                                        double y = 0.0;
                                        String value = "";
                                        try {
                                            value = kxmlParser.getAttributeValue("", "x");
                                            if (value != null) {
                                                this.setOriginX(Double.parseDouble(value));
                                            }
                                            if ((value = kxmlParser.getAttributeValue("", "y")) == null) break;
                                            this.setOriginY(Double.parseDouble(value));
                                        }
                                        catch (Exception ex) {
                                            logger.log(Level.SEVERE, "", ex);
                                        }
                                        break;
                                    }
                                    if (kxmlParser.getName().compareTo("TileFormat") == 0) {
                                        String value = "";
                                        try {
                                            value = kxmlParser.getAttributeValue("", "width");
                                            if (value != null) {
                                                this.setMAPTILE_SIZEPX(Integer.parseInt(value));
                                            }
                                            if ((value = kxmlParser.getAttributeValue("", "height")) != null) {
                                                this.setMAPTILE_SIZEPX(Integer.parseInt(value));
                                            }
                                            if ((value = kxmlParser.getAttributeValue("", "extension")) == null) break;
                                            this.setIMAGE_FILENAMEENDING(value);
                                        }
                                        catch (Exception ex) {
                                            logger.log(Level.SEVERE, "", ex);
                                        }
                                        break;
                                    }
                                    if (kxmlParser.getName().compareTo("TileSets") != 0) break;
                                    this.parseTileSets(kxmlParser);
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                            }
                            tag = kxmlParser.next();
                        }
                        kxmlParser.require(1, null, null);
                    }
                    Object var21_23 = null;
                    if (this.tempRes == null) break block58;
                    length2222 = this.tempRes.size();
                }
                catch (Throwable throwable) {
                    Object var21_26 = null;
                    if (this.tempRes != null) {
                        int length2222 = this.tempRes.size();
                        this.resolutions = new double[length2222];
                        for (int i = 0; i < length2222; ++i) {
                            this.resolutions[i] = Double.valueOf(this.tempRes.elementAt(i).toString());
                        }
                        this.setZOOM_MAXLEVEL(length2222 - 1);
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "", e);
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (baf != null) {
                        baf.clear();
                    }
                    throw throwable;
                }
                this.resolutions = new double[length2222];
                for (int i = 0; i < length2222; ++i) {
                    this.resolutions[i] = Double.valueOf(this.tempRes.elementAt(i).toString());
                }
                this.setZOOM_MAXLEVEL(length2222 - 1);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "", e);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (baf != null) {
                baf.clear();
            }
            break block63;
            {
                catch (XmlPullParserException parser_ex) {
                    logger.log(Level.SEVERE, "", parser_ex);
                    Object var21_24 = null;
                    if (this.tempRes != null) {
                        int length2222 = this.tempRes.size();
                        this.resolutions = new double[length2222];
                        for (int i = 0; i < length2222; ++i) {
                            this.resolutions[i] = Double.valueOf(this.tempRes.elementAt(i).toString());
                        }
                        this.setZOOM_MAXLEVEL(length2222 - 1);
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "", e);
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (baf != null) {
                        baf.clear();
                    }
                    break block63;
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "", ioe);
                    Object var21_25 = null;
                    if (this.tempRes != null) {
                        int length2222 = this.tempRes.size();
                        this.resolutions = new double[length2222];
                        for (int i = 0; i < length2222; ++i) {
                            this.resolutions[i] = Double.valueOf(this.tempRes.elementAt(i).toString());
                        }
                        this.setZOOM_MAXLEVEL(length2222 - 1);
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "", e);
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (baf != null) {
                        baf.clear();
                    }
                }
            }
        }
    }

    public final void parseTileSets(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "TileSets");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("TileSet") == 0) {
                        String url = "";
                        String res = "";
                        try {
                            url = parser.getAttributeValue("", "href");
                            res = parser.getAttributeValue("", "units-per-pixel");
                            this.tempRes.add(res);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "", e);
                        }
                    }
                }
                case 3: {
                    if (parser.getName().compareTo("TileSets") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final KXmlParser createParser(byte[] f) {
        KXmlParser parser;
        block17: {
            int a;
            String string;
            byte[] buffer;
            ByteArrayInputStream br;
            parser = null;
            try {
                br = new ByteArrayInputStream(f);
                buffer = new byte[100];
                br.read(buffer);
                string = new String(buffer);
                a = string.toLowerCase().indexOf("<?xml");
                if (a != -1) {
                    string = string.substring(a, string.length());
                }
                StringBuffer st = new StringBuffer(string);
                String searchText = "encoding=\"";
                int index = st.toString().indexOf("encoding=\"");
                if (index > -1) {
                    st.delete(0, index + "encoding=\"".length());
                    encoding = st.toString().substring(0, st.toString().indexOf("\""));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                return null;
            }
            parser = new KXmlParser();
            br = new ByteArrayInputStream(f);
            buffer = new byte[100];
            br.read(buffer);
            string = new String(buffer);
            a = string.toLowerCase().indexOf("<?xml");
            if (a != -1) {
                string = string.substring(a, string.length());
                parser.setInput((InputStream)br, encoding);
            } else {
                parser.setInput((InputStream)br, encoding);
            }
            br.reset();
            Object var10_11 = null;
            buffer = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block17;
            }
            catch (Exception e) {}
            break block17;
            {
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "", ex);
                    Object var10_12 = null;
                    buffer = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block17;
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                buffer = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return parser;
    }

    public int isTMS() {
        return -1;
    }

    public String toString() {
        StringBuffer layer = new StringBuffer();
        try {
            int length = this.resolutions.length;
            StringBuffer res = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                res.append(this.resolutions[i]);
                if (i == length - 1) continue;
                res.append(":");
            }
            String offExtent = "";
            if (this.isOffline()) {
                offExtent = this.getOfflineExtent().toString(":");
            }
            layer.append(this.getFullNAME()).append(";").append(this.getType()).append("[").append(offExtent).append(">").append(this.getOfflineLayerName()).append("]").append(",").append(this.getURLtoString()).append(",").append(this.getIMAGE_FILENAMEENDING()).append(",").append(this.getZOOM_MAXLEVEL()).append(",").append(this.getZoomMinLevel()).append(",").append(this.getMAPTILE_SIZEPX()).append(",").append(this.getOriginX()).append(",").append(this.getOriginY()).append(",").append(this.getExtent().toString()).append(",").append(this.SRS).append(",").append(res.toString());
            return layer.toString();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "toString: ", e);
            return null;
        }
    }

    public double[] transformCenter(String toCRS) {
        try {
            return ConversionCoords.reproject((double)this.center.getX(), (double)this.center.getY(), (Projection)CRSFactory.getCRS((String)this.getSRS()), (Projection)CRSFactory.getCRS((String)toCRS));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "transformCoords: ", e);
            return null;
        }
    }

    public void setCenter(double x, double y) {
        this.center = new Point(x, y);
        this.currentExtent = ViewPort.calculateExtent((Point)this.getCenter(), (double)this.currentRes, (double)ViewPort.mapWidth, (double)ViewPort.mapHeight);
        double[] latLonCenter = this.transformCenter("EPSG:4326");
        this.getLatLonCenter().setCoordinates(latLonCenter);
    }

    public Point getCenter() {
        return new Point(this.center.getX(), this.center.getY());
    }

    public Pixel getUpperLeftCornerOfCenterMapTileInScreen(Pixel reuse) {
        Pixel out = reuse != null ? reuse : new Pixel(0, 0);
        Pixel tile = TileConversor.metersToTile((double)this.getCenter().getX(), (double)this.getCenter().getY(), (double)this.getResolutions()[this.getZoomLevel()], (double)(-this.getOriginX()), (double)(-this.getOriginY()));
        Extent e1 = TileConversor.tileMeterBounds((int)tile.getX(), (int)tile.getY(), (double)this.getResolutions()[this.getZoomLevel()]);
        Extent e2 = ViewPort.calculateExtent((Point)new Point(this.getCenter().getX(), this.getCenter().getY()), (double)this.getResolutions()[this.getZoomLevel()], (double)ViewPort.mapWidth, (double)ViewPort.mapHeight);
        int[] centerTopLeft = ViewPort.fromMapPoint((double[])new double[]{e1.getMinX(), e1.getMaxY()}, (double)e2.getMinX(), (double)e2.getMaxY(), (double)this.getResolutions()[this.getZoomLevel()]);
        out.setX(centerTopLeft[0]);
        out.setY(centerTopLeft[1]);
        return out;
    }

    public int[] getMapTileFromCenter() {
        Pixel tile = TileConversor.metersToTile((double)this.getCenter().getX(), (double)this.getCenter().getY(), (double)this.getResolutions()[this.getZoomLevel()], (double)(-this.getOriginX()), (double)(-this.getOriginY()));
        return new int[]{tile.getY(), tile.getX()};
    }

    public double[] fromPixels(int[] pxy) {
        pxy[0] = pxy[0] - ViewPort.mTouchMapOffsetX;
        pxy[1] = pxy[1] - ViewPort.mTouchMapOffsetY;
        double res = this.resolutions[this.getZoomLevel()];
        return ViewPort.toMapPoint((int[])pxy, (int)((int)ViewPort.mapWidth), (int)((int)ViewPort.mapHeight), (Point)this.getCenter(), (double)res);
    }

    public Pixel getCenterE6() {
        return null;
    }

    public int[] toPixels(double[] pxy) {
        double res = this.currentRes;
        Extent e = this.currentExtent;
        int[] result = ViewPort.fromMapPoint((double[])pxy, (double)e.getMinX(), (double)e.getMaxY(), (double)res);
        result[0] = result[0] + ViewPort.mTouchMapOffsetX;
        result[1] = result[1] + ViewPort.mTouchMapOffsetY;
        return result;
    }

    public void setZoomLevel(int z) {
        super.setZoomLevel(z);
        this.currentRes = this.resolutions[this.getZoomLevel()];
        this.currentExtent = ViewPort.calculateExtent((Point)this.getCenter(), (double)this.currentRes, (double)ViewPort.mapWidth, (double)ViewPort.mapHeight);
    }

    public void centerOnBBox() {
        if (this.isOffline()) {
            this.center = this.getOfflineExtent().getCenter();
            this.setZoomLevel((this.getZOOM_MAXLEVEL() - this.getZoomMinLevel()) / 2);
        } else {
            this.center = this.getExtent().getCenter();
            this.setZoomLevel(this.getZoomMinLevel());
        }
    }

    public String buildQuery(Extent e, int zoomLevel, double resolution) {
        return null;
    }

    public Extent getExtentIncludingCenter(Point center, int zoomLevel, Point origin) {
        Pixel tile = TileConversor.metersToTile((double)center.getX(), (double)center.getY(), (double)this.getResolutions()[zoomLevel], (double)(-this.getOriginX()), (double)(-this.getOriginY()));
        Extent ex = TileConversor.tileMeterBounds((int)tile.getX(), (int)tile.getY(), (double)this.getResolutions()[this.getZoomLevel()]);
        return ex;
    }

    public StringBuffer getQuadkey(int tileX, int tileY, int zoomLevel) {
        try {
            if (tileX == -1) {
                return null;
            }
            return TileConversor.tileXYToQuadKey((int)tileX, (int)tileY, (int)zoomLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pixel getTileNumber(Extent e, int zoomLevel, double resolution, Projection proj) {
        Pixel tile = TileConversor.metersToTile((double)e.getCenter().getX(), (double)e.getCenter().getY(), (double)resolution, (double)(-this.getOriginX()), (double)(-this.getOriginY()));
        return tile;
    }

    public Extent getTileExtent(int tileX, int tileY, double resolution, double originX, double originY) {
        Extent e1 = TileConversor.tileMeterBounds((int)tileX, (int)tileY, (double)resolution, (double)originX, (double)originY);
        return e1;
    }

    public int[] toPixelsFromLonLat(double[] pxy) {
        double res = ViewPort.LAT_LON_RES[this.getZoomLevel()];
        Extent e = ViewPort.calculateExtent((Point)this.getLatLonCenter(), (double)res, (double)ViewPort.mapWidth, (double)ViewPort.mapHeight);
        int[] result = ViewPort.fromMapPoint((double[])pxy, (double)e.getMinX(), (double)e.getMaxY(), (double)res);
        result[0] = result[0] + ViewPort.mTouchMapOffsetX;
        result[1] = result[1] + ViewPort.mTouchMapOffsetY;
        return result;
    }

    public Extent getCurrentExtent() {
        return this.currentExtent;
    }

    public double getCurrentRes() {
        return this.currentRes;
    }
}

