/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.summary;

import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.tilecache.renderer.MapRenderer;
import es.prodevelop.tilecache.renderer.MapRendererManager;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryInfo {
    private MapRenderer renderer;
    private int minZoomLevel;
    private int maxZoomLevel;
    private Extent downloadedExtent;
    private Extent rendererExtent;
    private String cityName;
    public static final String FILE_NAME = "layer.txt";
    public static final String TILES_DOWN = "tiles_downloaded";
    public static final String TILES_FAILED = "tiles_failed";
    public static final String TILES_SKIPPED = "tiles_skipped";
    public static final String TILES_FROM_FS = "tiles_fromFS";
    public static final String TILES_NOT_FOUND = "tiles_not_found";
    public static final String TILES_DELETED = "tiles_deleted";
    public static final String BYTES_DOWNLOADED = "bytes_downloaded";
    public static final String TIME_TO_DOWNLOAD = "time_to_download";
    public static final String MIN_ZOOM_LEVEL = "minZ";
    public static final String MAX_ZOOM_LEVEL = "maxZ";
    public static final String EXTENT = "downloaded_extent";
    public static final String NAME = "city_name";
    private Hashtable<String, String> props = new Hashtable();
    private String version;
    private String layerNameSuffix;

    public SummaryInfo(String renderer, Hashtable<String, String> props) throws Exception {
        String[] rend = renderer.split("\\;");
        this.renderer = MapRendererManager.getInstance().getMapRendererFactory().getMapRenderer(rend[0], rend[1].split(","));
        for (String next : props.keySet()) {
            this.props.put(next, props.get(next));
        }
    }

    public SummaryInfo(MapRenderer renderer, int minZoomLevel, int maxZoomLevel, Extent downloadedExtent, String version, String layerNameSuffix, String cityName, Extent rendererExtent) {
        this.renderer = renderer;
        this.minZoomLevel = minZoomLevel;
        this.maxZoomLevel = maxZoomLevel;
        this.version = version;
        this.downloadedExtent = downloadedExtent;
        renderer.setZoomMinLevel(minZoomLevel);
        renderer.setZOOM_MAXLEVEL(maxZoomLevel);
        this.rendererExtent = rendererExtent;
        this.layerNameSuffix = layerNameSuffix;
        this.cityName = cityName;
        this.fillProperties();
    }

    private void fillProperties() {
        this.put(MIN_ZOOM_LEVEL, String.valueOf(this.minZoomLevel));
        this.put(MAX_ZOOM_LEVEL, String.valueOf(this.maxZoomLevel));
        this.put(EXTENT, this.downloadedExtent.toString());
        this.put(NAME, this.cityName.toString());
    }

    public Hashtable<String, String> getProperties() {
        return this.props;
    }

    public void put(String key, String value) {
        this.props.put(key, value);
    }

    public String getValue(String key) {
        return this.props.get(key);
    }

    public MapRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(MapRenderer renderer) {
        this.renderer = renderer;
    }

    public int getMinZoomLevel() {
        return this.minZoomLevel;
    }

    public void setMinZoomLevel(int minZoomLevel) {
        this.minZoomLevel = minZoomLevel;
    }

    public int getMaxZoomLevel() {
        return this.maxZoomLevel;
    }

    public void setMaxZoomLevel(int maxZoomLevel) {
        this.maxZoomLevel = maxZoomLevel;
    }

    public Extent getDownloadedExtent() {
        return this.downloadedExtent;
    }

    public void setDownloadedExtent(Extent downloadedExtent) {
        this.downloadedExtent = downloadedExtent;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLayerNameSuffix() {
        return this.layerNameSuffix;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Extent getRendererExtent() {
        return this.rendererExtent;
    }
}

