/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.summary;

import es.prodevelop.gvsig.mini.exceptions.BaseException;
import es.prodevelop.tilecache.summary.SummaryInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class SummaryReader {
    private String dirPath;
    private String version;

    public SummaryReader(String dirPath, String version) {
        this.dirPath = dirPath;
        this.version = version;
    }

    public SummaryInfo readSummaryInfo() throws Exception {
        String renderer = "";
        File f = new File(this.dirPath + File.separator + this.version + "_" + "layer.txt");
        if (!f.exists()) {
            throw new BaseException(f.getAbsolutePath() + " not exists");
        }
        InputStreamReader configReader = null;
        BufferedReader reader = null;
        Hashtable<String, String> properties = null;
        if (f != null && f.exists()) {
            configReader = new FileReader(f);
            reader = new BufferedReader(configReader);
            String line = null;
            properties = new Hashtable<String, String>();
            int i = 0;
            while ((line = reader.readLine()) != null) {
                if (i == 0) {
                    renderer = line;
                    ++i;
                    continue;
                }
                String[] part = line.split("=");
                properties.put(part[0], part[1]);
            }
        }
        try {
            configReader.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            reader.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return new SummaryInfo(renderer, properties);
    }
}

