/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.tilecache.util;

import es.prodevelop.gvsig.mini.geom.Extent;
import es.prodevelop.gvsig.mini.geom.Point;
import es.prodevelop.gvsig.mini.utiles.Cancellable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Utilities {
    public static Hashtable canceledGroup = new Hashtable();
    private static int groupID = -10;

    public static String trimDecimals(String number, int numberDecimals) {
        try {
            int length = number.length();
            for (int i = 0; i < length; ++i) {
                if (String.valueOf(number.charAt(i)).compareTo(".") != 0) continue;
                return number.substring(0, i + numberDecimals + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return number;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.trim().compareTo("") == 0;
    }

    public static boolean checkValidExtent(Extent ex, String srs) {
        if (ex == null) {
            return false;
        }
        return !(ex.area() <= 0.0);
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        String blank = "%20";
        StringTokenizer st = new StringTokenizer(s.trim(), " ");
        int size = st.countTokens();
        if (size <= 0) {
            return s;
        }
        StringBuffer url = new StringBuffer();
        int i = 0;
        while (st.hasMoreTokens()) {
            url.append(st.nextToken());
            if (++i >= size) continue;
            url.append("%20");
        }
        return url.toString();
    }

    public static String parseNamedDescription(String description) {
        StringBuffer res = null;
        try {
            if (!Utilities.isEmpty(description)) {
                StringBuffer s = new StringBuffer(description);
                int size = s.length();
                boolean skip = false;
                res = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    char ch = s.charAt(i);
                    if (ch == '<' || ch == '[') {
                        skip = true;
                    }
                    if (!skip) {
                        res.append(s.charAt(i));
                    }
                    if (ch != '>' && ch != ']') continue;
                    skip = false;
                }
            }
            return res.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized Integer getCancellableID() {
        return new Integer(groupID--);
    }

    public static synchronized Cancellable getNewCancellable() {
        Cancellable c = new Cancellable();
        c.groupID = new Integer(++groupID);
        return c;
    }

    public static void quicksort(Point[] a, Point center) {
        Utilities.quicksort(a, 0, a.length - 1, center);
    }

    private static void quicksort(Point[] a, int left, int right, Point center) {
        if (right <= left) {
            return;
        }
        int i = Utilities.partition(a, left, right, center);
        Utilities.quicksort(a, left, i - 1, center);
        Utilities.quicksort(a, i + 1, right, center);
    }

    private static int partition(Point[] a, int left, int right, Point center) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (Utilities.less(a[++i].distance(center), a[right].distance(center))) {
                continue;
            }
            while (Utilities.less(a[right].distance(center), a[right].distance(center)) && j != left) {
            }
            if (i >= j) break;
            Utilities.exch(a, i, j);
        }
        Utilities.exch(a, i, right);
        return i;
    }

    private static boolean less(double x, double y) {
        return x < y;
    }

    private static void exch(Point[] a, int i, int j) {
        Point swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }
}

