/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api;

import eu.aschuetz.nativeutils.api.FreeBSDNativeUtil;
import eu.aschuetz.nativeutils.api.JVMNativeUtil;
import eu.aschuetz.nativeutils.api.LinuxNativeUtil;
import eu.aschuetz.nativeutils.api.MacOSNativeUtil;
import eu.aschuetz.nativeutils.api.NativeUtil;
import eu.aschuetz.nativeutils.api.NativeUtilsProvider;
import eu.aschuetz.nativeutils.api.NetBSDNativeUtil;
import eu.aschuetz.nativeutils.api.NoopNativeUtil;
import eu.aschuetz.nativeutils.api.OpenBSDNativeUtil;
import eu.aschuetz.nativeutils.api.PosixNativeUtil;
import eu.aschuetz.nativeutils.api.WindowsNativeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;

public final class NativeUtils {
    private static NativeUtil instance;
    private static NativeUtilsProvider provider;

    public static void set(NativeUtil instance) {
        NativeUtils.instance = instance;
    }

    public static void setProvider(NativeUtilsProvider instance) {
        provider = instance;
        NativeUtils.instance = null;
    }

    public static boolean isWindows() {
        return NativeUtils.get().isWindows();
    }

    public static boolean isLinux() {
        return NativeUtils.get().isLinux();
    }

    public static boolean isJVM() {
        return NativeUtils.get().isJVM();
    }

    public static boolean isFreeBSD() {
        return NativeUtils.get().isFreeBSD();
    }

    public static boolean isNetBSD() {
        return NativeUtils.get().isNetBSD();
    }

    public static boolean isOpenBSD() {
        return NativeUtils.get().isOpenBSD();
    }

    public static boolean isMacOS() {
        return NativeUtils.get().isMacOS();
    }

    public static boolean isPosix() {
        return NativeUtils.get().isPosix();
    }

    public static JVMNativeUtil getJVMUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof JVMNativeUtil) {
            return (JVMNativeUtil)util;
        }
        throw new UnsupportedOperationException("JVM functions not supported.");
    }

    public static LinuxNativeUtil getLinuxUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof LinuxNativeUtil) {
            return (LinuxNativeUtil)util;
        }
        throw new UnsupportedOperationException("Linux functions not supported.");
    }

    public static WindowsNativeUtil getWindowsUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof WindowsNativeUtil) {
            return (WindowsNativeUtil)util;
        }
        throw new UnsupportedOperationException("Windows functions not supported.");
    }

    public static FreeBSDNativeUtil getFreeBSDUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof FreeBSDNativeUtil) {
            return (FreeBSDNativeUtil)util;
        }
        throw new UnsupportedOperationException("FreeBSD functions not supported.");
    }

    public static NetBSDNativeUtil getNetBSDUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof NetBSDNativeUtil) {
            return (NetBSDNativeUtil)util;
        }
        throw new UnsupportedOperationException("NetBSD functions not supported.");
    }

    public static OpenBSDNativeUtil getOpenBSDUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof OpenBSDNativeUtil) {
            return (OpenBSDNativeUtil)util;
        }
        throw new UnsupportedOperationException("OpenBSD functions not supported.");
    }

    public static MacOSNativeUtil getMacOSUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof MacOSNativeUtil) {
            return (MacOSNativeUtil)util;
        }
        throw new UnsupportedOperationException("MacOS functions not supported.");
    }

    public static PosixNativeUtil getPosixUtil() {
        NativeUtil util = NativeUtils.get();
        if (util instanceof PosixNativeUtil) {
            return (PosixNativeUtil)util;
        }
        throw new UnsupportedOperationException("Posix functions not supported.");
    }

    static NativeUtilsProvider getProvider() {
        if (provider != null) {
            return provider;
        }
        ClassLoader loaderToUse = Thread.currentThread().getContextClassLoader();
        if (loaderToUse == null) {
            loaderToUse = NativeUtils.class.getClassLoader();
        }
        ServiceLoader<NativeUtilsProvider> providers = ServiceLoader.load(NativeUtilsProvider.class, loaderToUse);
        ArrayList<NativeUtilsProvider> enabled = new ArrayList<NativeUtilsProvider>();
        for (NativeUtilsProvider provider : providers) {
            if (!provider.isEnabled()) continue;
            enabled.add(provider);
        }
        if (enabled.isEmpty()) {
            System.err.println("No NativeUtilsProvider is loaded and enabled. There is a classpath issue. Will not do anything...");
            return null;
        }
        if (enabled.size() != 1) {
            System.err.println("Multiple NativeUtilsProvider are loaded and enabled. There is a classpath issue. Will not do anything...");
            return null;
        }
        provider = (NativeUtilsProvider)enabled.get(0);
        return provider;
    }

    public static NativeUtil get() {
        if (instance != null) {
            return instance;
        }
        NativeUtilsProvider theProvider = NativeUtils.getProvider();
        if (theProvider == null) {
            instance = new NoopNativeUtil();
            return instance;
        }
        NativeUtil theUtil = theProvider.get();
        if (theUtil == null) {
            System.err.println("NativeUtilsProvider.get() returned null!");
            instance = new NoopNativeUtil();
            return instance;
        }
        instance = theUtil;
        return instance;
    }

    public static Map<String, byte[]> getNativeLibraryBinaries() {
        NativeUtilsProvider provider = NativeUtils.getProvider();
        if (provider == null) {
            return Collections.emptyMap();
        }
        return provider.getNativeLibraryBinaries();
    }
}

