/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api;

import java.nio.ByteOrder;

public class StructHelper {
    private static final boolean BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    public static int byteSwapInt(int swap) {
        return (swap >>> 0 & 0xFF) << 24 | (swap >>> 8 & 0xFF) << 16 | (swap >>> 16 & 0xFF) << 8 | (swap >>> 24 & 0xFF) << 0;
    }

    public static long byteSwapUInt(long swap) {
        return (swap >>> 0 & 0xFFL) << 24 | (swap >>> 8 & 0xFFL) << 16 | (swap >>> 16 & 0xFFL) << 8 | (swap >>> 24 & 0xFFL) << 0;
    }

    public static long byteSwapLong(long swap) {
        return (swap >>> 0 & 0xFFL) << 56 | (swap >>> 8 & 0xFFL) << 48 | (swap >>> 16 & 0xFFL) << 40 | (swap >>> 24 & 0xFFL) << 32 | (swap >>> 32 & 0xFFL) << 24 | (swap >>> 40 & 0xFFL) << 16 | (swap >>> 48 & 0xFFL) << 8 | (swap >>> 56 & 0xFFL) << 0;
    }

    public static short byteSwapShort(short swap) {
        int value = (swap >>> 0 & 0xFF) << 8 | (swap >>> 8 & 0xFF) << 0;
        return (short)value;
    }

    public static int byteSwapUShort(int swap) {
        return (swap >>> 0 & 0xFF) << 8 | (swap >>> 8 & 0xFF) << 0;
    }

    public static int readInt(byte[] buf, int off) {
        return BIG_ENDIAN ? ((buf[off++] & 0xFF) << 24) + ((buf[off++] & 0xFF) << 16) + ((buf[off++] & 0xFF) << 8) + ((buf[off] & 0xFF) << 0) : ((buf[off++] & 0xFF) << 0) + ((buf[off++] & 0xFF) << 8) + ((buf[off++] & 0xFF) << 16) + ((buf[off] & 0xFF) << 24);
    }

    public static short readShort(byte[] buf, int off) {
        return (short)StructHelper.readUShort(buf, off);
    }

    public static long readLong(byte[] buf, int off) {
        return BIG_ENDIAN ? ((long)(buf[off++] & 0xFF) << 56) + ((long)(buf[off++] & 0xFF) << 48) + ((long)(buf[off++] & 0xFF) << 40) + ((long)(buf[off++] & 0xFF) << 32) + ((long)(buf[off++] & 0xFF) << 24) + ((long)(buf[off++] & 0xFF) << 16) + ((long)(buf[off++] & 0xFF) << 8) + ((long)(buf[off] & 0xFF) << 0) : ((long)(buf[off++] & 0xFF) << 0) + ((long)(buf[off++] & 0xFF) << 8) + ((long)(buf[off++] & 0xFF) << 16) + ((long)(buf[off++] & 0xFF) << 24) + ((long)(buf[off++] & 0xFF) << 32) + ((long)(buf[off++] & 0xFF) << 40) + ((long)(buf[off++] & 0xFF) << 48) + ((long)(buf[off] & 0xFF) << 56);
    }

    public static float readFloat(byte[] buf, int off) {
        return Float.intBitsToFloat(StructHelper.readInt(buf, off));
    }

    public static double readDouble(byte[] buf, int off) {
        return Double.longBitsToDouble(StructHelper.readLong(buf, off));
    }

    public static int readUShort(byte[] buf, int off) {
        return BIG_ENDIAN ? ((buf[off] & 0xFF) << 8) + ((buf[off + 1] & 0xFF) << 0) : ((buf[off] & 0xFF) << 0) + ((buf[off + 1] & 0xFF) << 8);
    }

    public static long readUInt(byte[] buf, int off) {
        return (long)StructHelper.readInt(buf, off) & 0xFFFFFFFFL;
    }

    public static int readUByte(byte[] buf, int off) {
        return buf[off] & 0xFF;
    }

    public static byte readByte(byte[] buf, int off) {
        return buf[off];
    }

    public static void writeByte(byte[] buf, int off, byte value) {
        buf[off] = value;
    }

    public static void writeByte(byte[] buf, int off, int value) {
        buf[off] = (byte)value;
    }

    public static void writeShort(byte[] buf, int off, short value) {
        StructHelper.writeShort(buf, off, (int)value);
    }

    public static void writeShort(byte[] buf, int off, int value) {
        if (BIG_ENDIAN) {
            buf[off++] = (byte)(value >>> 8);
            buf[off] = (byte)(value >>> 0);
            return;
        }
        buf[off++] = (byte)(value >>> 0);
        buf[off] = (byte)(value >>> 8);
    }

    public static void writeInt(byte[] buf, int off, int value) {
        if (BIG_ENDIAN) {
            buf[off++] = (byte)(value >>> 24);
            buf[off++] = (byte)(value >>> 16);
            buf[off++] = (byte)(value >>> 8);
            buf[off] = (byte)(value >>> 0);
            return;
        }
        buf[off++] = (byte)(value >>> 0);
        buf[off++] = (byte)(value >>> 8);
        buf[off++] = (byte)(value >>> 16);
        buf[off] = (byte)(value >>> 24);
    }

    public static void writeInt(byte[] buf, int off, long value) {
        StructHelper.writeInt(buf, off, (int)value);
    }

    public static void writeLong(byte[] buf, int off, long value) {
        if (BIG_ENDIAN) {
            buf[off++] = (byte)(value >>> 56);
            buf[off++] = (byte)(value >>> 48);
            buf[off++] = (byte)(value >>> 40);
            buf[off++] = (byte)(value >>> 32);
            buf[off++] = (byte)(value >>> 24);
            buf[off++] = (byte)(value >>> 16);
            buf[off++] = (byte)(value >>> 8);
            buf[off] = (byte)(value >>> 0);
            return;
        }
        buf[off++] = (byte)(value >>> 0);
        buf[off++] = (byte)(value >>> 8);
        buf[off++] = (byte)(value >>> 16);
        buf[off++] = (byte)(value >>> 24);
        buf[off++] = (byte)(value >>> 32);
        buf[off++] = (byte)(value >>> 40);
        buf[off++] = (byte)(value >>> 48);
        buf[off] = (byte)(value >>> 56);
    }

    public static int htonl(int num) {
        if (BIG_ENDIAN) {
            return num;
        }
        return num >>> 24 | num >> 8 & 0xFF00 | num << 8 & 0xFF0000 | num << 24;
    }

    public static int htons(int num) {
        if (BIG_ENDIAN) {
            return num & 0xFFFF;
        }
        return num >> 8 & 0xFF | num << 8 & 0xFF00;
    }

    public static int ntohl(int num) {
        if (BIG_ENDIAN) {
            return num;
        }
        return num >>> 24 | num >> 8 & 0xFF00 | num << 8 & 0xFF0000 | num << 24;
    }

    public static int ntohs(int num) {
        if (BIG_ENDIAN) {
            return num & 0xFFFF;
        }
        return num >> 8 & 0xFF | num << 8 & 0xFF00;
    }

    public static int ntohs(byte[] buf, int off) {
        return StructHelper.ntohs(StructHelper.readUShort(buf, off));
    }

    public static void htons(byte[] buf, int off, int value) {
        StructHelper.writeShort(buf, off, StructHelper.htons(value));
    }

    public static int ntohl(byte[] buf, int off) {
        return StructHelper.ntohs(StructHelper.readInt(buf, off));
    }

    public static void htonl(byte[] buf, int off, int value) {
        StructHelper.writeInt(buf, off, StructHelper.htonl(value));
    }
}

