/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api.structs;

import eu.aschuetz.nativeutils.api.StructHelper;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;

public class Sockaddr {
    private static final byte[] EMPTY = new byte[0];
    private int addressFamily;
    private byte[] address;

    public Sockaddr() {
        this(-1, EMPTY);
    }

    public Sockaddr(int addressFamily, byte[] address) {
        this.addressFamily = addressFamily;
        this.address = Objects.requireNonNull(address);
    }

    public Sockaddr(Sockaddr other) {
        this(-1, EMPTY);
        other.copyTo(this);
    }

    public int getAddressFamily() {
        return this.addressFamily;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public Sockaddr clone() {
        return new Sockaddr(this.addressFamily, Arrays.copyOf(this.address, this.address.length));
    }

    public void copyTo(Sockaddr other) {
        other.addressFamily = this.addressFamily;
        if (other.address.length == this.address.length) {
            System.arraycopy(this.address, 0, other.address, 0, this.address.length);
            return;
        }
        other.address = Arrays.copyOf(this.address, this.address.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sockaddr sockaddr = (Sockaddr)o;
        return this.addressFamily == sockaddr.addressFamily && Arrays.equals(this.address, sockaddr.address);
    }

    public int hashCode() {
        int result = Objects.hash(this.addressFamily);
        result = 31 * result + Arrays.hashCode(this.address);
        return result;
    }

    public InetSocketAddress parseWin32_SOCKADDR_INET() {
        if (this.address == null) {
            return null;
        }
        if (this.addressFamily == 2 && this.address.length >= 8) {
            int port = StructHelper.readUShort(this.address, 2);
            try {
                return new InetSocketAddress(InetAddress.getByAddress(new byte[]{this.address[4], this.address[5], this.address[6], this.address[7]}), port);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        if (this.addressFamily == 23 && this.address.length >= 24) {
            int port = StructHelper.readUShort(this.address, 2);
            byte[] addr = new byte[16];
            System.arraycopy(this.address, 8, addr, 0, 16);
            try {
                return new InetSocketAddress(InetAddress.getByAddress(addr), port);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return "Sockaddr{addressFamily=" + this.addressFamily + ", address=" + Arrays.toString(this.address) + '}';
    }
}

