/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api.structs;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class Stat {
    private long dev;
    private long ino;
    private long mode;
    private long nlink;
    private long uid;
    private long gid;
    private long rdev;
    private long size;
    private long blksize;
    private long blocks;
    private long atime;
    private long mtime;
    private long ctime;
    private static final int OR = 256;
    private static final int OW = 128;
    private static final int OE = 64;
    private static final int GR = 32;
    private static final int GW = 16;
    private static final int GE = 8;
    private static final int ER = 4;
    private static final int EW = 2;
    private static final int EE = 1;

    private Stat() {
    }

    public long getDev() {
        return this.dev;
    }

    public long getIno() {
        return this.ino;
    }

    public long getMode() {
        return this.mode;
    }

    public boolean isDir() {
        return (this.mode & 0x4000L) == 16384L;
    }

    public boolean isCharacterDevice() {
        return (this.mode & 0x2000L) == 8192L;
    }

    public boolean isBlockDevice() {
        return (this.mode & 0x6000L) == 24576L;
    }

    public boolean isRegularFile() {
        return (this.mode & 0x8000L) == 32768L;
    }

    public boolean isFIFO() {
        return (this.mode & 0x1000L) == 4096L;
    }

    public boolean isSymbolicLink() {
        return (this.mode & 0xA000L) == 40960L;
    }

    public boolean isSocket() {
        return (this.mode & 0xC000L) == 49152L;
    }

    public boolean canOwnerRead() {
        return (this.mode & 0x100L) == 256L;
    }

    public boolean canOwnerWrite() {
        return (this.mode & 0x80L) == 128L;
    }

    public boolean canOwnerExecute() {
        return (this.mode & 0x40L) == 64L;
    }

    public boolean canGroupRead() {
        return (this.mode & 0x20L) == 32L;
    }

    public boolean canGroupWrite() {
        return (this.mode & 0x10L) == 16L;
    }

    public boolean canGroupExecute() {
        return (this.mode & 8L) == 8L;
    }

    public boolean canOthersRead() {
        return (this.mode & 4L) == 4L;
    }

    public boolean canOthersWrite() {
        return (this.mode & 2L) == 2L;
    }

    public boolean canOthersExecute() {
        return (this.mode & 1L) == 1L;
    }

    public String getPermissions() {
        StringBuilder sb = new StringBuilder(9);
        sb.append(this.canOwnerRead() ? (char)'r' : '-');
        sb.append(this.canOwnerWrite() ? (char)'w' : '-');
        sb.append(this.canOwnerExecute() ? (char)'x' : '-');
        sb.append(this.canGroupRead() ? (char)'r' : '-');
        sb.append(this.canGroupWrite() ? (char)'w' : '-');
        sb.append(this.canGroupExecute() ? (char)'x' : '-');
        sb.append(this.canOthersRead() ? (char)'r' : '-');
        sb.append(this.canOthersWrite() ? (char)'w' : '-');
        sb.append(this.canOthersExecute() ? (char)'x' : '-');
        return sb.toString();
    }

    public long getNlink() {
        return this.nlink;
    }

    public long getUid() {
        return this.uid;
    }

    public long getGid() {
        return this.gid;
    }

    public long getRdev() {
        return this.rdev;
    }

    public long getSize() {
        return this.size;
    }

    public long getBlksize() {
        return this.blksize;
    }

    public long getBlocks() {
        return this.blocks;
    }

    public long getAtime() {
        return this.atime;
    }

    public long getMtime() {
        return this.mtime;
    }

    public long getCtime() {
        return this.ctime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("       Type: ");
        if (this.isSymbolicLink()) {
            sb.append("link");
        } else if (this.isDir()) {
            sb.append("directory");
        } else if (this.isRegularFile()) {
            sb.append("file");
        } else if (this.isCharacterDevice()) {
            sb.append("character device");
        } else if (this.isBlockDevice()) {
            sb.append("block device");
        } else if (this.isFIFO()) {
            sb.append("pipe");
        } else if (this.isSocket()) {
            sb.append("socket");
        } else {
            sb.append("other");
        }
        sb.append("\n");
        sb.append("       Size: ");
        sb.append(this.size);
        sb.append("\n");
        sb.append("        UID: ");
        sb.append(this.getUid());
        sb.append("\n");
        sb.append("        GID: ");
        sb.append(this.getGid());
        sb.append("\n");
        sb.append("Permissions: ");
        sb.append(this.getPermissions());
        sb.append("\n");
        sb.append("     Access: ");
        sb.append(new Date(TimeUnit.SECONDS.toMillis(this.getAtime())));
        sb.append("\n");
        sb.append("     Modify: ");
        sb.append(new Date(TimeUnit.SECONDS.toMillis(this.getMtime())));
        sb.append("\n");
        sb.append("     Change: ");
        sb.append(new Date(TimeUnit.SECONDS.toMillis(this.getCtime())));
        sb.append("\n");
        sb.append("     Blocks: ");
        sb.append(this.blocks);
        sb.append("\n");
        sb.append(" Block Size: ");
        sb.append(this.blksize);
        sb.append("\n");
        sb.append("     Device: ");
        sb.append(this.getDev());
        sb.append("\n");
        sb.append("      Inode: ");
        sb.append(this.getIno());
        sb.append("\n");
        sb.append("      Links: ");
        sb.append(this.getNlink());
        return sb.toString();
    }
}

