/*
 * Decompiled with CFR 0.152.
 */
package eu.sec.cert.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import eu.sec.cert.ApiCallback;
import eu.sec.cert.ApiClient;
import eu.sec.cert.ApiException;
import eu.sec.cert.ApiResponse;
import eu.sec.cert.Configuration;
import eu.sec.cert.Pair;
import eu.sec.cert.ProgressRequestBody;
import eu.sec.cert.ProgressResponseBody;
import eu.sec.cert.model.AccessRequest;
import eu.sec.cert.model.AccessResponse;
import eu.sec.cert.model.AdminAuth;
import eu.sec.cert.model.AdminResponse;
import eu.sec.cert.model.GroupsResponse;
import eu.sec.cert.model.LoginResponse;
import eu.sec.cert.model.PasswordRequirementsResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CaApiIamApi {
    private ApiClient apiClient;

    public CaApiIamApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CaApiIamApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAdminsCall(String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/identityfederation/admins/".replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAdminsValidateBeforeCall(String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getAdmins(Async)");
        }
        Call call = this.getAdminsCall(scope, progressListener, progressRequestListener);
        return call;
    }

    public AdminResponse getAdmins(String scope) throws ApiException {
        ApiResponse<AdminResponse> resp = this.getAdminsWithHttpInfo(scope);
        return resp.getData();
    }

    public ApiResponse<AdminResponse> getAdminsWithHttpInfo(String scope) throws ApiException {
        Call call = this.getAdminsValidateBeforeCall(scope, null, null);
        Type localVarReturnType = new TypeToken<AdminResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAdminsAsync(String scope, final ApiCallback<AdminResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAdminsValidateBeforeCall(scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AdminResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getObjectAccessCall(AccessRequest request, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AccessRequest localVarPostBody = request;
        String localVarPath = "/{scope}/identityfederation/data/access".replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getObjectAccessValidateBeforeCall(AccessRequest request, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling getObjectAccess(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getObjectAccess(Async)");
        }
        Call call = this.getObjectAccessCall(request, scope, progressListener, progressRequestListener);
        return call;
    }

    public AccessResponse getObjectAccess(AccessRequest request, String scope) throws ApiException {
        ApiResponse<AccessResponse> resp = this.getObjectAccessWithHttpInfo(request, scope);
        return resp.getData();
    }

    public ApiResponse<AccessResponse> getObjectAccessWithHttpInfo(AccessRequest request, String scope) throws ApiException {
        Call call = this.getObjectAccessValidateBeforeCall(request, scope, null, null);
        Type localVarReturnType = new TypeToken<AccessResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getObjectAccessAsync(AccessRequest request, String scope, final ApiCallback<AccessResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getObjectAccessValidateBeforeCall(request, scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccessResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPasswordRequirementsCall(String userId, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/identityfederation/{userId}/passwordRequirements".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPasswordRequirementsValidateBeforeCall(String userId, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getPasswordRequirements(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getPasswordRequirements(Async)");
        }
        Call call = this.getPasswordRequirementsCall(userId, scope, progressListener, progressRequestListener);
        return call;
    }

    public PasswordRequirementsResponse getPasswordRequirements(String userId, String scope) throws ApiException {
        ApiResponse<PasswordRequirementsResponse> resp = this.getPasswordRequirementsWithHttpInfo(userId, scope);
        return resp.getData();
    }

    public ApiResponse<PasswordRequirementsResponse> getPasswordRequirementsWithHttpInfo(String userId, String scope) throws ApiException {
        Call call = this.getPasswordRequirementsValidateBeforeCall(userId, scope, null, null);
        Type localVarReturnType = new TypeToken<PasswordRequirementsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPasswordRequirementsAsync(String userId, String scope, final ApiCallback<PasswordRequirementsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPasswordRequirementsValidateBeforeCall(userId, scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PasswordRequirementsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserAccessesCall(String userId, String scope, String from, String to, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/identityfederation/{userId}/logins".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserAccessesValidateBeforeCall(String userId, String scope, String from, String to, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserAccesses(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getUserAccesses(Async)");
        }
        Call call = this.getUserAccessesCall(userId, scope, from, to, limit, progressListener, progressRequestListener);
        return call;
    }

    public LoginResponse getUserAccesses(String userId, String scope, String from, String to, Integer limit) throws ApiException {
        ApiResponse<LoginResponse> resp = this.getUserAccessesWithHttpInfo(userId, scope, from, to, limit);
        return resp.getData();
    }

    public ApiResponse<LoginResponse> getUserAccessesWithHttpInfo(String userId, String scope, String from, String to, Integer limit) throws ApiException {
        Call call = this.getUserAccessesValidateBeforeCall(userId, scope, from, to, limit, null, null);
        Type localVarReturnType = new TypeToken<LoginResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserAccessesAsync(String userId, String scope, String from, String to, Integer limit, final ApiCallback<LoginResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserAccessesValidateBeforeCall(userId, scope, from, to, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LoginResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserAuthTypeCall(String userId, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/identityfederation/{userId}/auth".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserAuthTypeValidateBeforeCall(String userId, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserAuthType(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getUserAuthType(Async)");
        }
        Call call = this.getUserAuthTypeCall(userId, scope, progressListener, progressRequestListener);
        return call;
    }

    public AdminAuth getUserAuthType(String userId, String scope) throws ApiException {
        ApiResponse<AdminAuth> resp = this.getUserAuthTypeWithHttpInfo(userId, scope);
        return resp.getData();
    }

    public ApiResponse<AdminAuth> getUserAuthTypeWithHttpInfo(String userId, String scope) throws ApiException {
        Call call = this.getUserAuthTypeValidateBeforeCall(userId, scope, null, null);
        Type localVarReturnType = new TypeToken<AdminAuth>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserAuthTypeAsync(String userId, String scope, final ApiCallback<AdminAuth> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserAuthTypeValidateBeforeCall(userId, scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AdminAuth>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserOrganisationCall(String userId, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/identityfederation/{userId}/groups".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserOrganisationValidateBeforeCall(String userId, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserOrganisation(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getUserOrganisation(Async)");
        }
        Call call = this.getUserOrganisationCall(userId, scope, progressListener, progressRequestListener);
        return call;
    }

    public GroupsResponse getUserOrganisation(String userId, String scope) throws ApiException {
        ApiResponse<GroupsResponse> resp = this.getUserOrganisationWithHttpInfo(userId, scope);
        return resp.getData();
    }

    public ApiResponse<GroupsResponse> getUserOrganisationWithHttpInfo(String userId, String scope) throws ApiException {
        Call call = this.getUserOrganisationValidateBeforeCall(userId, scope, null, null);
        Type localVarReturnType = new TypeToken<GroupsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserOrganisationAsync(String userId, String scope, final ApiCallback<GroupsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserOrganisationValidateBeforeCall(userId, scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GroupsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

