/*
 * Decompiled with CFR 0.152.
 */
package eu.sec.cert.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import eu.sec.cert.ApiCallback;
import eu.sec.cert.ApiClient;
import eu.sec.cert.ApiException;
import eu.sec.cert.ApiResponse;
import eu.sec.cert.Configuration;
import eu.sec.cert.Pair;
import eu.sec.cert.ProgressRequestBody;
import eu.sec.cert.ProgressResponseBody;
import eu.sec.cert.model.ObjectResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CaApiObjectsApi {
    private ApiClient apiClient;

    public CaApiObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CaApiObjectsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getObjectsCall(String scope, String from, String to, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/objects/".replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getObjectsValidateBeforeCall(String scope, String from, String to, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getObjects(Async)");
        }
        Call call = this.getObjectsCall(scope, from, to, limit, progressListener, progressRequestListener);
        return call;
    }

    public ObjectResponse getObjects(String scope, String from, String to, Integer limit) throws ApiException {
        ApiResponse<ObjectResponse> resp = this.getObjectsWithHttpInfo(scope, from, to, limit);
        return resp.getData();
    }

    public ApiResponse<ObjectResponse> getObjectsWithHttpInfo(String scope, String from, String to, Integer limit) throws ApiException {
        Call call = this.getObjectsValidateBeforeCall(scope, from, to, limit, null, null);
        Type localVarReturnType = new TypeToken<ObjectResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getObjectsAsync(String scope, String from, String to, Integer limit, final ApiCallback<ObjectResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getObjectsValidateBeforeCall(scope, from, to, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ObjectResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

