/*
 * Decompiled with CFR 0.152.
 */
package eu.sec.cert.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import eu.sec.cert.ApiCallback;
import eu.sec.cert.ApiClient;
import eu.sec.cert.ApiException;
import eu.sec.cert.ApiResponse;
import eu.sec.cert.Configuration;
import eu.sec.cert.Pair;
import eu.sec.cert.ProgressRequestBody;
import eu.sec.cert.ProgressResponseBody;
import eu.sec.cert.model.EncryptionStorageResponse;
import eu.sec.cert.model.GeoLocation;
import eu.sec.cert.model.LocationStorageResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CaApiPersistenceApi {
    private ApiClient apiClient;

    public CaApiPersistenceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CaApiPersistenceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getEncryptionInfoCall(String objectId, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/persistence/{objectId}/encryption".replaceAll("\\{objectId\\}", this.apiClient.escapeString(objectId.toString())).replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEncryptionInfoValidateBeforeCall(String objectId, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (objectId == null) {
            throw new ApiException("Missing the required parameter 'objectId' when calling getEncryptionInfo(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getEncryptionInfo(Async)");
        }
        Call call = this.getEncryptionInfoCall(objectId, scope, progressListener, progressRequestListener);
        return call;
    }

    public EncryptionStorageResponse getEncryptionInfo(String objectId, String scope) throws ApiException {
        ApiResponse<EncryptionStorageResponse> resp = this.getEncryptionInfoWithHttpInfo(objectId, scope);
        return resp.getData();
    }

    public ApiResponse<EncryptionStorageResponse> getEncryptionInfoWithHttpInfo(String objectId, String scope) throws ApiException {
        Call call = this.getEncryptionInfoValidateBeforeCall(objectId, scope, null, null);
        Type localVarReturnType = new TypeToken<EncryptionStorageResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEncryptionInfoAsync(String objectId, String scope, final ApiCallback<EncryptionStorageResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEncryptionInfoValidateBeforeCall(objectId, scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EncryptionStorageResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLocationCall(String objectId, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/persistence/{objectId}/location/".replaceAll("\\{objectId\\}", this.apiClient.escapeString(objectId.toString())).replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLocationValidateBeforeCall(String objectId, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (objectId == null) {
            throw new ApiException("Missing the required parameter 'objectId' when calling getLocation(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getLocation(Async)");
        }
        Call call = this.getLocationCall(objectId, scope, progressListener, progressRequestListener);
        return call;
    }

    public GeoLocation getLocation(String objectId, String scope) throws ApiException {
        ApiResponse<GeoLocation> resp = this.getLocationWithHttpInfo(objectId, scope);
        return resp.getData();
    }

    public ApiResponse<GeoLocation> getLocationWithHttpInfo(String objectId, String scope) throws ApiException {
        Call call = this.getLocationValidateBeforeCall(objectId, scope, null, null);
        Type localVarReturnType = new TypeToken<GeoLocation>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLocationAsync(String objectId, String scope, final ApiCallback<GeoLocation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLocationValidateBeforeCall(objectId, scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GeoLocation>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getStorageCall(String objectId, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{scope}/persistence/{objectId}/storage/".replaceAll("\\{objectId\\}", this.apiClient.escapeString(objectId.toString())).replaceAll("\\{scope\\}", this.apiClient.escapeString(scope.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key", "basic_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getStorageValidateBeforeCall(String objectId, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (objectId == null) {
            throw new ApiException("Missing the required parameter 'objectId' when calling getStorage(Async)");
        }
        if (scope == null) {
            throw new ApiException("Missing the required parameter 'scope' when calling getStorage(Async)");
        }
        Call call = this.getStorageCall(objectId, scope, progressListener, progressRequestListener);
        return call;
    }

    public LocationStorageResponse getStorage(String objectId, String scope) throws ApiException {
        ApiResponse<LocationStorageResponse> resp = this.getStorageWithHttpInfo(objectId, scope);
        return resp.getData();
    }

    public ApiResponse<LocationStorageResponse> getStorageWithHttpInfo(String objectId, String scope) throws ApiException {
        Call call = this.getStorageValidateBeforeCall(objectId, scope, null, null);
        Type localVarReturnType = new TypeToken<LocationStorageResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getStorageAsync(String objectId, String scope, final ApiCallback<LocationStorageResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getStorageValidateBeforeCall(objectId, scope, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LocationStorageResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

