package fi.evolver.script.system;

import java.util.List;
import java.util.stream.Collectors;

import fi.evolver.script.FileUtil;
import fi.evolver.script.Shell;

public class Hosts {
	public static void addHostBlock(String blockId, List<HostMapping> hosts) {
		String block = hosts.stream()
				.map(HostMapping::toLine)
				.collect(Collectors.joining("\n"));

		addHostBlock(blockId, block);
	}

	public static void addHostBlock(String blockId, String hostsBlock) {
		String originalContents = Shell.sudo("cat", "/etc/hosts");
		String updatedContents = FileUtil.addShellBlock(originalContents, blockId, hostsBlock);
		FileUtil.sudoWrite("/etc/hosts", updatedContents, "root:root", "644");
	}

	public record HostMapping(String ip, String host) {
		public static HostMapping localhost(String host) {
			return new HostMapping("127.0.0.1", host);
		}

		public String toLine() {
			return "%s\t%s".formatted(ip, host);
		}
	}
}
