/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script;

import fi.evolver.script.FileUtil;
import fi.evolver.script.Step;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;

public class Download {
    public static Path intoTempFile(String url) {
        try (Step step = Step.start("Download temp file");){
            URI uri = URI.create(url);
            String filename = uri.getPath().substring(uri.getPath().lastIndexOf(47) + 1);
            int lastDotIndex = filename.lastIndexOf(46);
            String prefix = lastDotIndex > -1 ? filename.substring(0, lastDotIndex) : filename;
            String suffix = lastDotIndex > -1 ? filename.substring(lastDotIndex) : ".tmp";
            Path tempFile = FileUtil.createTempFile(prefix, suffix);
            Download.intoFile(uri, tempFile);
            Path path = tempFile;
            return path;
        }
    }

    public static void intoFile(URI uri, Path target) {
        try (Step step = Step.start("Download file from %s to %s".formatted(uri, target));
             HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();){
            HttpRequest request = HttpRequest.newBuilder().uri(uri).build();
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFile(target));
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to download file: HTTP error code " + response.statusCode());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String contentString(String url) {
        return Download.contentString(URI.create(url));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String contentString(URI uri) {
        try (Step step = Step.start("Download contents from %s".formatted(uri));){
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(uri).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    throw new RuntimeException("Failed to download file: HTTP error code " + response.statusCode());
                }
                String string = response.body();
                if (client != null) {
                    client.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] contentBytes(String url) {
        return Download.contentBytes(URI.create(url));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] contentBytes(URI uri) {
        try (Step step = Step.start("Download bytes from %s".formatted(uri));){
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(uri).build();
                HttpResponse<byte[]> response = client.send(request, HttpResponse.BodyHandlers.ofByteArray());
                if (response.statusCode() != 200) {
                    throw new RuntimeException("Failed to download file: HTTP error code " + response.statusCode());
                }
                byte[] byArray = response.body();
                if (client != null) {
                    client.close();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

