/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script;

import fi.evolver.script.Dialog;
import fi.evolver.script.Step;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.SequenceInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;

public class Shell {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setDaemon(true);
        return thread;
    });
    public static final Path HOME = Path.of(System.getProperty("user.home"), new String[0]);
    public static final Path BASHRC = HOME.resolve(".bashrc");
    public static final String USER = System.getProperty("user.name");
    private static String password;

    public static String user(String ... command) {
        return Shell.user(Arrays.asList(command));
    }

    public static String user(List<String> command) {
        return Command.user(command).run().stdout();
    }

    public static String sudo(String ... command) {
        return Shell.sudo(Arrays.asList(command));
    }

    public static String sudo(List<String> command) {
        return Command.sudo(command).run().stdout();
    }

    private static String readTextStream(InputStream inputStream, PrintStream output) throws IOException {
        char[] buffer = new char[8192];
        StringBuilder builder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(inputStream));){
            int count;
            while ((count = reader.read(buffer)) != -1) {
                String chunk = new String(buffer, 0, count);
                builder.append(chunk);
                if (!Step.DEBUG_ENABLED || output == null) continue;
                output.print(chunk);
                output.flush();
            }
        }
        return builder.toString();
    }

    private static byte[] readBinaryStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream collector = new ByteArrayOutputStream();
        inputStream.transferTo(collector);
        return collector.toByteArray();
    }

    public static class Command {
        private final List<String> command;
        private final Map<String, String> environment = new LinkedHashMap<String, String>();
        private Optional<InputStream> stdin = Optional.empty();
        private boolean failOnError = true;
        private Path workingDirectory;
        private boolean binaryStdout;

        private Command(List<String> command) {
            this.command = command;
        }

        public Command env(String variable, String value) {
            this.environment.put(variable, value);
            return this;
        }

        public Command stdin(InputStream data) {
            this.stdin = Stream.concat(this.stdin.stream(), Optional.ofNullable(data).stream()).reduce(SequenceInputStream::new);
            return this;
        }

        public Command stdin(String data) {
            return this.getStdin(data.getBytes());
        }

        private Command getStdin(byte[] bytes) {
            return this.stdin(new ByteArrayInputStream(bytes));
        }

        public Command failOnError(boolean value) {
            this.failOnError = value;
            return this;
        }

        public Command workingDirectory(Path path) {
            this.workingDirectory = path;
            return this;
        }

        public Command binaryStdout(boolean value) {
            this.binaryStdout = value;
            return this;
        }

        public boolean isSudo() {
            return "sudo".equals(this.command.stream().findFirst().orElse("-"));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.isSudo() ? (char)'#' : '$');
            this.command.forEach(p -> builder.append(" ").append((String)p));
            return builder.toString();
        }

        public static Command user(String ... command) {
            return Command.user(Arrays.asList(command));
        }

        public static Command user(List<String> command) {
            return new Command(command);
        }

        public static Command sudo(String ... command) {
            return Command.sudo(Arrays.asList(command));
        }

        public static Command sudo(List<String> command) {
            if ("root".equals(System.getProperty("user.name"))) {
                return Command.user(command);
            }
            if (password == null) {
                password = Dialog.readPassword("Please input user password for using sudo");
            }
            ArrayList<String> parts = new ArrayList<String>();
            parts.addAll(List.of("sudo", "-S", "-k", "-p", ""));
            parts.addAll(command);
            return new Command(parts).stdin(password);
        }

        public Result run() {
            Step step = Step.start(this.toString());
            try {
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command(this.command);
                builder.environment().putAll(this.environment);
                if (this.workingDirectory != null) {
                    builder.directory(this.workingDirectory.toFile());
                }
                Process process = builder.start();
                CompletableFuture<Object> futureStdoutText = this.binaryStdout ? CompletableFuture.completedFuture(null) : EXECUTOR.submit(() -> Shell.readTextStream(process.getInputStream(), System.out));
                CompletableFuture<Object> futureStdoutBytes = this.binaryStdout ? EXECUTOR.submit(() -> Shell.readBinaryStream(process.getInputStream())) : CompletableFuture.completedFuture(null);
                Future<String> futureStderr = EXECUTOR.submit(() -> Shell.readTextStream(process.getErrorStream(), System.err));
                if (this.stdin.isPresent()) {
                    try (BufferedOutputStream out = new BufferedOutputStream(process.getOutputStream());){
                        this.stdin.get().transferTo(out);
                    }
                }
                int exitValue = process.waitFor();
                Result result = new Result(exitValue, (byte[])futureStdoutBytes.get(), (String)futureStdoutText.get(), futureStderr.get());
                if (this.failOnError && !result.success()) {
                    if (Step.DEBUG_ENABLED) {
                        step.fail("FAILED");
                    } else {
                        step.fail("STDOUT:\n%s\nSTDERR:\n%s".formatted(this.binaryStdout ? "(binary data)" : result.stdout(), result.stderr()));
                    }
                }
                Result result2 = result;
                if (step != null) {
                    step.close();
                }
                return result2;
            }
            catch (Throwable throwable) {
                try {
                    if (step != null) {
                        try {
                            step.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ExecutionException e) {
                    throw new RuntimeException("Failed executing a command", e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while executing a command", e);
                }
            }
        }
    }

    public record Result(int exitValue, byte[] binaryStdout, String stdout, String stderr) {
        public boolean success() {
            return this.exitValue == 0;
        }
    }
}

