/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Download;
import fi.evolver.script.FileUtil;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Apt {
    public static void install(String ... packageNames) {
        try (Step step = Step.start("Install %s".formatted(String.join((CharSequence)", ", packageNames)));){
            Shell.sudo(Stream.concat(Stream.of("apt-get", "install", "-y"), Arrays.stream(packageNames)).toList());
        }
    }

    public static void installFromUrl(String url) {
        try (Step step = Step.start("Install deb from %s".formatted(url));){
            Path debPath = Download.intoTempFile(url);
            Apt.install(debPath.toString());
        }
    }

    public static void purge(String ... packageNames) {
        try (Step step = Step.start("Purge %s".formatted(String.join((CharSequence)", ", packageNames)));){
            Shell.sudo(Stream.concat(Stream.of("apt-get", "purge", "-y"), Arrays.stream(packageNames)).toList());
        }
    }

    public static void update() {
        try (Step step = Step.start("Update package lists");){
            Shell.sudo("apt-get", "update");
        }
    }

    public static boolean isInstalled(String packageName) {
        return Shell.Command.user("dpkg-query", "-W", packageName).failOnError(false).run().success();
    }

    public static void addPublicKey(String keyringName, URI url) {
        Apt.ensureInstalled("gpg");
        byte[] pubKeyBytes = Download.contentBytes(url);
        byte[] dearmoredPubkey = Shell.Command.user("gpg", "--dearmor").stdin(new ByteArrayInputStream(pubKeyBytes)).binaryStdout(true).run().binaryStdout();
        FileUtil.sudoWrite("/etc/apt/keyrings/%s".formatted(keyringName), dearmoredPubkey, "root:root", "644");
    }

    public static void ensureInstalled(String ... packageNames) {
        String[] notInstalled = (String[])Arrays.stream(packageNames).filter(Predicate.not(Apt::isInstalled)).toArray(String[]::new);
        if (notInstalled.length > 0) {
            Apt.update();
            Apt.install(notInstalled);
        }
    }

    public static void addSource(String sourceIdentifier, String sourceFileContent) {
        FileUtil.sudoWrite("/etc/apt/sources.list.d/%s.list".formatted(sourceIdentifier), sourceFileContent, "root:root", "644");
    }

    public static String getArchitecture() {
        return Shell.user("dpkg", "--print-architecture").trim();
    }
}

