/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.FileUtil;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import java.net.URI;

public class Kubectl {
    private static final String KUBERNETES_KEYRING_NAME = "kubernetes-apt-keyring.gpg";

    public static void install(String kubectlVersion) {
        try (Step step = Step.start("Kubectl: install");){
            Apt.addPublicKey(KUBERNETES_KEYRING_NAME, URI.create("https://pkgs.k8s.io/core:/stable:/v%s/deb/Release.key".formatted(kubectlVersion)));
            Apt.addSource("kubernetes", "deb [signed-by=/etc/apt/keyrings/%s] https://pkgs.k8s.io/core:/stable:/v%s/deb/ /".formatted(KUBERNETES_KEYRING_NAME, kubectlVersion));
            Apt.update();
            Apt.install("kubectl");
            FileUtil.addShellBlock(Shell.BASHRC, "kubectl config", "source <(kubectl completion bash)\nalias k=kubectl\ncomplete -o default -F __start_kubectl k\n");
        }
    }
}

