/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.FileUtil;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Git;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Nvm {
    private static final String REPOSITORY_URL = "https://github.com/nvm-sh/nvm.git";
    private static final String CONFIG = "export NVM_DIR=\"$HOME/.nvm\"\n[ -s \"$NVM_DIR/nvm.sh\" ] && \\. \"$NVM_DIR/nvm.sh\"  # This loads nvm\n[ -s \"$NVM_DIR/bash_completion\" ] && \\. \"$NVM_DIR/bash_completion\"\n";

    public static Node use(Path workingDirectory) {
        return Nvm.use(workingDirectory, null);
    }

    public static Node use(String version) {
        return Nvm.use(Path.of(".", new String[0]), version);
    }

    public static Node use(Path workingDirectory, String versionOverride) {
        Step step = Step.start("Nvm: use version %s".formatted(versionOverride));
        try {
            Path result;
            if (workingDirectory == null || !Files.isDirectory(workingDirectory, new LinkOption[0])) {
                step.fail("Invalid working directory '%s'".formatted(workingDirectory));
            }
            Nvm.install();
            String version = versionOverride != null ? versionOverride : Nvm.getVersionFromNvmRc(workingDirectory);
            String exactVersion = Nvm.command("version", version).stdout().trim();
            if ("N/A".equalsIgnoreCase(exactVersion)) {
                if (!Nvm.command("install", version).success()) {
                    step.fail("Could not find npm version %s".formatted(version));
                }
                exactVersion = Nvm.command("version", version).stdout().trim();
            }
            if (!Files.isDirectory(result = Shell.HOME.resolve(".nvm/versions/node").resolve(exactVersion).resolve("bin"), new LinkOption[0])) {
                step.fail("Could not find the npm directory for version %s (%s)".formatted(exactVersion, result));
            }
            Node node = new Node(result, workingDirectory);
            if (step != null) {
                step.close();
            }
            return node;
        }
        catch (Throwable throwable) {
            try {
                if (step != null) {
                    try {
                        step.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getVersionFromNvmRc(Path workingDirectory) throws IOException {
        Path nvmRc = Nvm.resolveNvmrc(workingDirectory).orElseThrow();
        return Files.readString(nvmRc).trim();
    }

    private static Optional<Path> resolveNvmrc(Path workingDirectory) {
        while (workingDirectory != null) {
            if (Files.exists(workingDirectory.resolve(".nvmrc"), new LinkOption[0])) {
                return Optional.of(workingDirectory.resolve(".nvmrc"));
            }
            workingDirectory = workingDirectory.getParent();
        }
        return Optional.empty();
    }

    public static void install() {
        try (Step step = Step.start("Nvm: install");){
            Path targetDir = Shell.HOME.resolve(".nvm");
            if (Files.exists(targetDir, new LinkOption[0])) {
                step.skip("Already installed");
                return;
            }
            Git.clone(REPOSITORY_URL, targetDir);
            try {
                FileUtil.addShellBlock(Shell.BASHRC, "NVM", CONFIG);
            }
            catch (RuntimeException e) {
                step.fail("Could not write configuration", e);
            }
        }
    }

    private static Shell.Result command(String ... args) {
        String escaped = Arrays.stream(args).map(arg_0 -> Nvm.lambda$command$0("'%s'", arg_0)).collect(Collectors.joining(" "));
        try (Step step = Step.start("npm %s".formatted(escaped));){
            if (Arrays.stream(args).anyMatch(c -> c.contains("'"))) {
                throw new IllegalArgumentException("Nvm command contains ', which is not supported");
            }
            Shell.Result result = Shell.Command.user("bash", "-c", "export NVM_DIR=$HOME/.nvm; source $NVM_DIR/nvm.sh; nvm %s".formatted(escaped)).failOnError(false).run();
            return result;
        }
    }

    private static /* synthetic */ String lambda$command$0(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }

    public record Node(Path bin, Path workingDirectory) {
        public Shell.Command command(String ... args) {
            return this.command(Arrays.asList(args));
        }

        public Shell.Command command(List<String> args) {
            try (Step step = Step.start("Node: %s".formatted(args));){
                ArrayList<String> fullCommand = new ArrayList<String>();
                fullCommand.add(this.bin().resolve("node").toString());
                fullCommand.addAll(args);
                Shell.Command command = Shell.Command.user(fullCommand).workingDirectory(this.workingDirectory).env("PATH", "%s:%s".formatted(this.bin(), System.getenv("PATH")));
                return command;
            }
        }

        public void npm(String ... args) {
            this.npm(Arrays.asList(args));
        }

        public void npm(List<String> args) {
            try (Step step = Step.start("Npm: %s".formatted(String.join((CharSequence)" ", args)));){
                ArrayList<String> fullCommand = new ArrayList<String>(args.size() + 1);
                fullCommand.add(this.bin().resolve("npm").toString());
                fullCommand.addAll(args);
                this.command(fullCommand).run();
            }
        }

        public Node withWorkingDirectory(Path workingDirectory) {
            return new Node(this.bin, workingDirectory);
        }
    }
}

