/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Download;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.system.Architecture;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class Idea {
    private static final String INSTALL_URL_PREFIX = "https://download.jetbrains.com/idea/ideaIU-";
    private static final String INSTALL_URL_SUFFIX_AMD64 = ".tar.gz";
    private static final String INSTALL_URL_SUFFIX_ARM64 = "-aarch64.tar.gz";
    public static final String PLUGIN_GRAILS = "org.intellij.grails";
    public static final String PLUGIN_MAKEFILE = "name.kropp.intellij.makefile";
    public static final String PLUGIN_JREBEL = "JRebelPlugin";
    public static final String PLUGIN_DOTENV = "ru.adelf.idea.dotenv";
    public static final String PLUGIN_ENV_FILE = "net.ashald.envfile";
    public static final String PLUGIN_MULTIPROJECT_WORKSPACES = "org.jetbrains.plugins.workspace";
    private static final Path APPS_DIR = Shell.HOME.resolve("apps");
    private static final Path INSTALL_DIR = APPS_DIR.resolve("IntelliJIdeaUltimate");

    public static void install(String version) throws IOException {
        try (Step step = Step.start("IntelliJ Idea: install");){
            if (Files.exists(INSTALL_DIR, new LinkOption[0])) {
                step.skip("IntelliJ Idea Ultimate is already installed");
                return;
            }
            Files.createDirectories(APPS_DIR, new FileAttribute[0]);
            URI ideaUrl = switch (Architecture.validated()) {
                default -> throw new MatchException(null, null);
                case Architecture.AMD64 -> URI.create(INSTALL_URL_PREFIX + version + INSTALL_URL_SUFFIX_AMD64);
                case Architecture.ARM64 -> URI.create(INSTALL_URL_PREFIX + version + INSTALL_URL_SUFFIX_ARM64);
            };
            Path downloadedTarGz = Download.intoTempFile(ideaUrl);
            Shell.user("tar", "-xzf", downloadedTarGz.toString(), "-C", APPS_DIR.toString());
            try (Stream<Path> dirStream = Files.list(APPS_DIR);){
                Path extractedDir = dirStream.filter(p -> Files.isDirectory(p, new LinkOption[0]) && p.getFileName().toString().startsWith("idea-IU")).findFirst().orElseThrow(() -> new RuntimeException("Extracted IntelliJ Idea folder not found"));
                Files.move(extractedDir, INSTALL_DIR, new CopyOption[0]);
            }
        }
    }

    public static void installPublicPlugins(List<String> pluginIds) {
        try (Step step = Step.start("Install IDEA plugins");){
            Path ideaSh = INSTALL_DIR.resolve("bin/idea.sh");
            if (!Files.exists(ideaSh, new LinkOption[0])) {
                step.fail("idea.sh not found in " + String.valueOf(ideaSh));
            }
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add(ideaSh.toString());
            tokens.add("installPlugins");
            tokens.addAll(pluginIds);
            Shell.user(tokens);
        }
    }
}

