/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.example.springboot;

import fun.fengwk.chatjava.core.client.ChatClient;
import fun.fengwk.chatjava.core.client.ChatClientProvider;
import fun.fengwk.chatjava.core.client.ChatCompletionsResponse;
import fun.fengwk.chatjava.core.client.StreamChatListener;
import fun.fengwk.chatjava.core.client.request.ChatMessage;
import fun.fengwk.chatjava.core.client.request.ChatRequest;
import fun.fengwk.chatjava.core.client.response.ChatResponse;
import fun.fengwk.chatjava.core.client.util.ChatUtils;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class ExampleApplication {
    public static void main(String[] args) throws ExecutionException, InterruptedException {
        ConfigurableApplicationContext applicationContext = SpringApplication.run(ExampleApplication.class, (String[])args);
        ChatClientProvider chatClientProvider = (ChatClientProvider)applicationContext.getBean(ChatClientProvider.class);
        ChatClient chatClient = chatClientProvider.getChatClient();
        ChatRequest chatRequest = new ChatRequest();
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        messages.add(ChatMessage.newUserMessage((String)"\u95ee\u5019\u8bed\u201c\u5403\u4e86\u4e48\u201d\u5728\u82f1\u8bed\u91cc\u600e\u4e48\u8bf4"));
        chatRequest.setMessages(messages);
        chatRequest.setModel("deepseek-chat");
        CompletableFuture future = chatClient.streamChatCompletions(chatRequest, new StreamChatListener(){

            public void onReceive(ChatCompletionsResponse response) {
                System.out.print(ChatUtils.getContent((ChatResponse)response.getChatResponse()));
            }

            public void onComplete() {
                System.out.println();
            }
        });
        future.get();
    }
}

