/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.starter.client;

import fun.fengwk.chatjava.core.client.ChatClientProvider;
import fun.fengwk.chatjava.core.client.tool.DefaultToolFunctionHandlerRegistry;
import fun.fengwk.chatjava.core.client.tool.ToolFunctionHandlerRegistry;
import fun.fengwk.chatjava.starter.client.ChatClientProperties;
import fun.fengwk.chatjava.starter.client.SpringChatClientProvider;
import fun.fengwk.chatjava.starter.client.ToolFunctionPostprocessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ChatClientProperties.class})
@AutoConfiguration
public class ChatClientAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public ToolFunctionHandlerRegistry toolFunctionHandlerRegistry() {
        return new DefaultToolFunctionHandlerRegistry();
    }

    @Bean
    public ToolFunctionPostprocessor toolFunctionPostprocessor(ToolFunctionHandlerRegistry toolFunctionHandlerRegistry) {
        return new ToolFunctionPostprocessor(toolFunctionHandlerRegistry);
    }

    @ConditionalOnMissingBean
    @Bean
    public ChatClientProvider chatClientProvider(ToolFunctionHandlerRegistry toolFunctionHandlerRegistry, ChatClientProperties chatClientProperties) {
        return new SpringChatClientProvider(toolFunctionHandlerRegistry, chatClientProperties);
    }
}

