/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.starter.client;

import fun.fengwk.chatjava.core.client.ChatClientOptions;
import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import fun.fengwk.chatjava.core.client.util.httpclient.ImmutableListableProxies;
import fun.fengwk.chatjava.core.client.util.httpclient.ListableProxies;
import fun.fengwk.chatjava.core.client.util.httpclient.ProxyBuilder;
import fun.fengwk.chatjava.core.client.util.httpclient.ProxySelectorAdapter;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;

@ConfigurationProperties(value="chat.client")
public class ChatClientProperties
implements InitializingBean {
    private List<ProxyBuilder> proxies = Collections.emptyList();
    private Duration connectTimeout = Duration.ofSeconds(5L);
    private ChatClientOptions defaultChatClientOptions = new ChatClientOptions();
    private volatile HttpClient httpClientCache;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void afterPropertiesSet() {
        this.httpClientCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient() {
        if (this.httpClientCache != null) {
            return this.httpClientCache;
        }
        ChatClientProperties chatClientProperties = this;
        synchronized (chatClientProperties) {
            if (this.httpClientCache != null) {
                return this.httpClientCache;
            }
            List proxies = ChatMiscUtils.nullSafe(this.getProxies()).stream().map(ProxyBuilder::newProxy).collect(Collectors.toList());
            this.httpClientCache = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).connectTimeout(this.getConnectTimeout()).proxy((ProxySelector)new ProxySelectorAdapter((ListableProxies)new ImmutableListableProxies(proxies))).build();
            return this.httpClientCache;
        }
    }

    public List<ProxyBuilder> getProxies() {
        return this.proxies;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public ChatClientOptions getDefaultChatClientOptions() {
        return this.defaultChatClientOptions;
    }

    public HttpClient getHttpClientCache() {
        return this.httpClientCache;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setProxies(List<ProxyBuilder> proxies) {
        this.proxies = proxies;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setDefaultChatClientOptions(ChatClientOptions defaultChatClientOptions) {
        this.defaultChatClientOptions = defaultChatClientOptions;
    }

    public void setHttpClientCache(HttpClient httpClientCache) {
        this.httpClientCache = httpClientCache;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatClientProperties)) {
            return false;
        }
        ChatClientProperties other = (ChatClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ProxyBuilder> this$proxies = this.getProxies();
        List<ProxyBuilder> other$proxies = other.getProxies();
        if (this$proxies == null ? other$proxies != null : !((Object)this$proxies).equals(other$proxies)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        ChatClientOptions this$defaultChatClientOptions = this.getDefaultChatClientOptions();
        ChatClientOptions other$defaultChatClientOptions = other.getDefaultChatClientOptions();
        if (this$defaultChatClientOptions == null ? other$defaultChatClientOptions != null : !this$defaultChatClientOptions.equals(other$defaultChatClientOptions)) {
            return false;
        }
        HttpClient this$httpClientCache = this.getHttpClientCache();
        HttpClient other$httpClientCache = other.getHttpClientCache();
        if (this$httpClientCache == null ? other$httpClientCache != null : !this$httpClientCache.equals(other$httpClientCache)) {
            return false;
        }
        ApplicationEventPublisher this$applicationEventPublisher = this.getApplicationEventPublisher();
        ApplicationEventPublisher other$applicationEventPublisher = other.getApplicationEventPublisher();
        return !(this$applicationEventPublisher == null ? other$applicationEventPublisher != null : !this$applicationEventPublisher.equals(other$applicationEventPublisher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ProxyBuilder> $proxies = this.getProxies();
        result = result * 59 + ($proxies == null ? 43 : ((Object)$proxies).hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        ChatClientOptions $defaultChatClientOptions = this.getDefaultChatClientOptions();
        result = result * 59 + ($defaultChatClientOptions == null ? 43 : $defaultChatClientOptions.hashCode());
        HttpClient $httpClientCache = this.getHttpClientCache();
        result = result * 59 + ($httpClientCache == null ? 43 : $httpClientCache.hashCode());
        ApplicationEventPublisher $applicationEventPublisher = this.getApplicationEventPublisher();
        result = result * 59 + ($applicationEventPublisher == null ? 43 : $applicationEventPublisher.hashCode());
        return result;
    }

    public String toString() {
        return "ChatClientProperties(proxies=" + String.valueOf(this.getProxies()) + ", connectTimeout=" + String.valueOf(this.getConnectTimeout()) + ", defaultChatClientOptions=" + String.valueOf(this.getDefaultChatClientOptions()) + ", httpClientCache=" + String.valueOf(this.getHttpClientCache()) + ", applicationEventPublisher=" + String.valueOf(this.getApplicationEventPublisher()) + ")";
    }
}

