/*
 * Decompiled with CFR 0.152.
 */
package hr.hrg.javawatcher;

import hr.hrg.javawatcher.FileChangeType;
import hr.hrg.javawatcher.FileMatcher;
import java.nio.file.Path;

public class FileChangeEntry<T extends FileMatcher> {
    private final Path file;
    private final T matcher;
    private final FileChangeType type;

    public FileChangeEntry(Path file, FileChangeType type, T matcher) {
        this.file = file;
        this.type = type;
        this.matcher = matcher;
    }

    public Path getPath() {
        return this.file;
    }

    public T getMatcher() {
        return this.matcher;
    }

    public FileChangeType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.matcher == null ? 0 : this.matcher.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileChangeEntry other = (FileChangeEntry)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.matcher == null ? other.matcher != null : !this.matcher.equals(other.matcher)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return this.file.toAbsolutePath() + " " + (Object)((Object)this.type);
    }
}

