/*
 * Decompiled with CFR 0.152.
 */
package hr.hrg.javawatcher;

import hr.hrg.javawatcher.FileMatcher;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMatchGlob
implements FileMatcher {
    private static final String NOT_COLLECTING_EXCLUDED = "This matcher is not collecting excluded files. Call setCollectExcluded(true) or override this method if you do not want exception thrown. ";
    private static final String NOT_COLLECTING_MATCHES = "This matcher is not collecting matches. Call setCollectMatched(true) or override this method if you do not want exception thrown. ";
    static final Logger log = LoggerFactory.getLogger(FileMatchGlob.class);
    protected String rootString;
    protected boolean recursive;
    protected List<PathMatcher> includes = new ArrayList<PathMatcher>();
    protected List<PathMatcher> excludes = new ArrayList<PathMatcher>();
    protected volatile boolean started = false;
    protected Path rootPath;
    protected boolean collectMatched = true;
    protected Set<Path> matched = new TreeSet<Path>();
    protected boolean collectExcluded = false;
    protected Set<Path> excluded = new TreeSet<Path>();

    public FileMatchGlob(Path root, boolean recursive) {
        this.rootPath = root;
        this.recursive = recursive;
        this.rootString = this.rootPath.toString().replace('\\', '/');
    }

    public PathMatcher makeRule(String rule) {
        if (rule.startsWith("regex:")) {
            return FileSystems.getDefault().getPathMatcher(rule);
        }
        return FileSystems.getDefault().getPathMatcher("glob:" + this.rootString + "/" + rule);
    }

    public FileMatchGlob includes(Collection<String> globs) {
        for (String glob : globs) {
            this.includes.add(this.makeRule(glob));
        }
        return this;
    }

    public FileMatchGlob includes(String ... globs) {
        String[] stringArray = globs;
        int n = globs.length;
        int n2 = 0;
        while (n2 < n) {
            String glob = stringArray[n2];
            this.includes.add(this.makeRule(glob));
            ++n2;
        }
        return this;
    }

    public FileMatchGlob excludes(Collection<String> globs) {
        for (String glob : globs) {
            this.excludes.add(this.makeRule(glob));
        }
        return this;
    }

    public FileMatchGlob excludes(String ... globs) {
        String[] stringArray = globs;
        int n = globs.length;
        int n2 = 0;
        while (n2 < n) {
            String glob = stringArray[n2];
            this.excludes.add(this.makeRule(glob));
            ++n2;
        }
        return this;
    }

    public static final void removeAllFromDir(Path path, Collection<Path> collection) {
        Iterator<Path> iterator = collection.iterator();
        Path p = null;
        while (iterator.hasNext()) {
            p = iterator.next();
            if (!path.equals(p.getParent())) continue;
            iterator.remove();
        }
    }

    public List<PathMatcher> getExcludes() {
        return this.excludes;
    }

    public List<PathMatcher> getIncludes() {
        return this.includes;
    }

    @Override
    public Path relativize(Path path) {
        return this.rootPath.relativize(path);
    }

    @Override
    public Collection<Path> getMatched() {
        if (!this.collectMatched) {
            throw new RuntimeException(NOT_COLLECTING_MATCHES + this.toString());
        }
        return this.matched;
    }

    public int getMatchedCount() {
        if (!this.collectMatched) {
            throw new RuntimeException(NOT_COLLECTING_MATCHES + this.toString());
        }
        return this.matched.size();
    }

    public Collection<Path> getExcluded() {
        if (!this.collectExcluded) {
            throw new RuntimeException(NOT_COLLECTING_EXCLUDED + this.toString());
        }
        return this.excluded;
    }

    public int getExcludedCount() {
        if (!this.collectExcluded) {
            throw new RuntimeException(NOT_COLLECTING_EXCLUDED + this.toString());
        }
        return this.excluded.size();
    }

    public boolean isCollectExcluded() {
        return this.collectExcluded;
    }

    public boolean isCollectMatched() {
        return this.collectMatched;
    }

    public void setCollectExcluded(boolean collectExcluded) {
        this.collectExcluded = collectExcluded;
    }

    @Override
    public void setCollectMatched(boolean collectMatched) {
        this.collectMatched = collectMatched;
    }

    @Override
    public boolean isMatch(Path path) {
        if (this.includes.size() > 0) {
            boolean included = false;
            for (PathMatcher inc : this.includes) {
                if (!inc.matches(path)) continue;
                included = true;
                break;
            }
            if (!included) {
                return false;
            }
        }
        for (PathMatcher ex : this.excludes) {
            if (!ex.matches(path)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isExcluded(Path path) {
        for (PathMatcher ex : this.excludes) {
            if (!ex.matches(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fileDeleted(Path path) {
        this.matched.remove(path);
        this.excluded.remove(path);
    }

    @Override
    public void dirInvalid(Path path) {
        FileMatchGlob.removeAllFromDir(path, this.matched);
        FileMatchGlob.removeAllFromDir(path, this.excluded);
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean offer(Path file) {
        if (this.isMatch(file)) {
            if (this.collectMatched) {
                this.matched.add(file);
            }
            return true;
        }
        if (this.collectExcluded) {
            this.excluded.add(file);
        }
        return false;
    }

    public String toString() {
        return "FileMatchGlob:" + this.rootString;
    }
}

