/*
 * Decompiled with CFR 0.152.
 */
package hr.hrg.javawatcher;

import hr.hrg.javawatcher.FileChangeEntry;
import hr.hrg.javawatcher.FileChangeType;
import hr.hrg.javawatcher.FileMatcher;
import hr.hrg.javawatcher.WatchEntry;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderWatcher<F extends FileMatcher> {
    Logger log = LoggerFactory.getLogger(FolderWatcher.class);
    protected final Map<WatchKey, WatchEntry<F>> keys = new HashMap<WatchKey, WatchEntry<F>>();
    protected List<F> matchers = new ArrayList<F>();
    private WatchService watchService;

    public F add(F matcher) {
        this.matchers.add(matcher);
        return matcher;
    }

    public Collection<FileChangeEntry<F>> poll() {
        WatchKey key = this.watchService.poll();
        return key == null ? null : this.getFilesOrNull(key);
    }

    public Collection<FileChangeEntry<F>> takeBatch(long burstDelay) {
        try {
            Collection<FileChangeEntry<F>> batch = this.take();
            Collection<FileChangeEntry<F>> changed = null;
            while (!Thread.interrupted()) {
                changed = this.poll(burstDelay, TimeUnit.MILLISECONDS);
                if (changed == null && batch.size() > 0) {
                    return batch;
                }
                if (changed == null) continue;
                batch.addAll(changed);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public Collection<FileChangeEntry<F>> poll(long timeout, TimeUnit unit) throws InterruptedException {
        WatchKey key = this.watchService.poll(timeout, unit);
        return key == null ? null : this.getFilesOrNull(key);
    }

    public Collection<FileChangeEntry<F>> take() throws InterruptedException {
        while (!Thread.interrupted()) {
            Collection<FileChangeEntry<F>> files = this.getFiles(this.watchService.take());
            if (files.size() <= 0) continue;
            return files;
        }
        throw new InterruptedException("take interrupted");
    }

    public Collection<FileChangeEntry<F>> takeOrNull() {
        try {
            return this.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public List<F> getMatchers() {
        return this.matchers;
    }

    public Collection<FileChangeEntry<F>> getMatched() {
        ArrayList<FileChangeEntry<F>> matched = new ArrayList<FileChangeEntry<F>>();
        for (FileMatcher m : this.matchers) {
            for (Path p : m.getMatched()) {
                matched.add(new FileChangeEntry<FileMatcher>(p, FileChangeType.MODIFY, m));
            }
        }
        return matched;
    }

    public Collection<Path> getMatchedFiles() {
        ArrayList<Path> matched = new ArrayList<Path>();
        for (FileMatcher m : this.matchers) {
            matched.addAll(m.getMatched());
        }
        return matched;
    }

    public Set<Path> getMatchedFilesUnique() {
        HashSet<Path> matched = new HashSet<Path>();
        for (FileMatcher m : this.matchers) {
            matched.addAll(m.getMatched());
        }
        return matched;
    }

    protected void register(Path dir, F matcher) throws IOException {
        WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        WatchEntry<Object> prev = this.keys.get(key);
        this.log.debug("watch {} for {}", (Object)dir, matcher);
        if (prev == null) {
            prev = new WatchEntry(dir);
            this.keys.put(key, prev);
        }
        if (!prev.getMatchers().contains(matcher)) {
            prev.getMatchers().add(matcher);
        }
    }

    public void init(boolean registerForWatch) {
        if (registerForWatch && this.watchService == null) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        for (FileMatcher matcher : this.matchers) {
            this.initMatcher(matcher, registerForWatch);
        }
    }

    protected void initMatcher(final F matcher, final boolean registerForWatch) {
        try {
            if (registerForWatch) {
                this.register(matcher.getRootPath(), matcher);
            }
            Files.walkFileTree(matcher.getRootPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    matcher.offer(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return matcher.isRecursive() && !matcher.isExcluded(dir) || dir.equals(matcher.getRootPath()) ? super.preVisitDirectory(dir, attrs) : FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (registerForWatch && !matcher.isExcluded(dir)) {
                        FolderWatcher.this.register(dir, matcher);
                    }
                    return super.postVisitDirectory(dir, exc);
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void fillMatcher(final FileMatcher matcher) {
        try {
            final boolean recursive = matcher.isRecursive();
            final Path rootPath = matcher.getRootPath();
            matcher.setCollectMatched(true);
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    matcher.offer(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return recursive && !matcher.isExcluded(dir) || dir.equals(rootPath) ? super.preVisitDirectory(dir, attrs) : FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Collection<FileChangeEntry<F>> getFilesOrNull(WatchKey key) {
        Collection<FileChangeEntry<F>> files = this.getFiles(key);
        if (files.size() == 0) {
            return null;
        }
        return files;
    }

    protected Collection<FileChangeEntry<F>> getFiles(WatchKey key) {
        ArrayList<FileChangeEntry<F>> files = new ArrayList<FileChangeEntry<F>>();
        WatchEntry<F> dir = this.keys.get(key);
        for (WatchEvent<?> event : key.pollEvents()) {
            FileChangeType type = FileChangeType.fromKind(event.kind());
            if (type == null) continue;
            WatchEvent<?> ev = event;
            Path filename = dir.getFolder().resolve((Path)ev.context());
            for (FileMatcher matcher : dir.getMatchers()) {
                if (!matcher.offer(filename)) continue;
                files.add(new FileChangeEntry<FileMatcher>(filename, type, matcher));
                if (type != FileChangeType.DELETE) continue;
                matcher.fileDeleted(filename);
            }
        }
        boolean valid = key.reset();
        if (!valid) {
            key.cancel();
            for (FileMatcher matcher : dir.getMatchers()) {
                matcher.dirInvalid(dir.getFolder());
            }
        }
        return files;
    }
}

