/*
 * Decompiled with CFR 0.152.
 */
package hr.hrg.javawatcher;

import hr.hrg.javawatcher.FileChangeEntry;
import hr.hrg.javawatcher.FileMatchGlob;
import hr.hrg.javawatcher.FolderWatcher;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class GlobWatcher {
    FolderWatcher<FileMatchGlob> watcher = new FolderWatcher();
    FileMatchGlob matcher;

    public Path relativize(Path path) {
        return this.matcher.relativize(path);
    }

    public FileMatchGlob add(FileMatchGlob matcher) {
        return this.watcher.add(matcher);
    }

    public GlobWatcher(Path root, boolean recursive) {
        this.matcher = new FileMatchGlob(root, recursive);
        this.watcher.add(this.matcher);
    }

    public GlobWatcher(Path root) {
        this(root, true);
    }

    public static final Collection<Path> toPaths(Collection<FileChangeEntry<FileMatchGlob>> changes) {
        if (changes == null) {
            return null;
        }
        ArrayList<Path> paths = new ArrayList<Path>(changes.size());
        for (FileChangeEntry<FileMatchGlob> p : changes) {
            paths.add(p.getPath());
        }
        return paths;
    }

    public static final Collection<Path> toPathsUnique(Collection<FileChangeEntry<FileMatchGlob>> changes) {
        if (changes == null) {
            return null;
        }
        HashSet<Path> paths = new HashSet<Path>(changes.size());
        for (FileChangeEntry<FileMatchGlob> p : changes) {
            paths.add(p.getPath());
        }
        return paths;
    }

    public Collection<FileChangeEntry<FileMatchGlob>> poll() {
        return this.watcher.poll();
    }

    public Collection<Path> pollFiles() {
        return GlobWatcher.toPaths(this.watcher.poll());
    }

    public Collection<FileChangeEntry<FileMatchGlob>> takeBatch(long burstDelay) {
        return this.watcher.takeBatch(burstDelay);
    }

    public Collection<Path> takeBatchFiles(long burstDelay) {
        return GlobWatcher.toPaths(this.watcher.takeBatch(burstDelay));
    }

    public Collection<Path> takeBatchFilesUnique(long burstDelay) {
        return GlobWatcher.toPathsUnique(this.watcher.takeBatch(burstDelay));
    }

    public Collection<FileChangeEntry<FileMatchGlob>> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.watcher.poll(timeout, unit);
    }

    public Collection<Path> pollFiles(long timeout, TimeUnit unit) throws InterruptedException {
        return GlobWatcher.toPaths(this.watcher.poll(timeout, unit));
    }

    public Collection<FileChangeEntry<FileMatchGlob>> take() throws InterruptedException {
        return this.watcher.take();
    }

    public Collection<Path> takeFiles() throws InterruptedException {
        return GlobWatcher.toPaths(this.watcher.take());
    }

    public Collection<FileChangeEntry<FileMatchGlob>> takeOrNull() {
        return this.watcher.takeOrNull();
    }

    public Collection<Path> takeOrNullFiles() {
        return GlobWatcher.toPaths(this.watcher.takeOrNull());
    }

    public Collection<FileChangeEntry<FileMatchGlob>> getMatched() {
        return this.watcher.getMatched();
    }

    public Collection<Path> getMatchedFiles() {
        return this.watcher.getMatchedFiles();
    }

    public Set<Path> getMatchedFilesUnique() {
        return this.watcher.getMatchedFilesUnique();
    }

    public void init(boolean registerForWatch) {
        this.watcher.init(registerForWatch);
    }

    public FileMatchGlob includes(Collection<String> globs) {
        return this.matcher.includes(globs);
    }

    public FileMatchGlob includes(String ... globs) {
        return this.matcher.includes(globs);
    }

    public FileMatchGlob excludes(Collection<String> globs) {
        return this.matcher.excludes(globs);
    }

    public FileMatchGlob excludes(String ... globs) {
        return this.matcher.excludes(globs);
    }

    public List<PathMatcher> getExcludes() {
        return this.matcher.getExcludes();
    }

    public List<PathMatcher> getIncludes() {
        return this.matcher.getIncludes();
    }

    public Collection<Path> getExcluded() {
        return this.matcher.getExcluded();
    }

    public int getExcludedCount() {
        return this.matcher.getExcludedCount();
    }

    public boolean isCollectExcluded() {
        return this.matcher.isCollectExcluded();
    }

    public boolean isCollectMatched() {
        return this.matcher.isCollectMatched();
    }

    public void setCollectExcluded(boolean collectExcluded) {
        this.matcher.setCollectExcluded(collectExcluded);
    }

    public void setCollectMatched(boolean collectMatched) {
        this.matcher.setCollectMatched(collectMatched);
    }

    public boolean isMatch(Path path) {
        return this.matcher.isMatch(path);
    }

    public boolean isExcluded(Path path) {
        return this.matcher.isExcluded(path);
    }

    public Path getRootPath() {
        return this.matcher.getRootPath();
    }

    public boolean isRecursive() {
        return this.matcher.isRecursive();
    }
}

