/*
 * Decompiled with CFR 0.152.
 */
package id.devcode.openapi;

import id.devcode.openapi.OpenApiProperties;
import id.devcode.openapi.factory.ActuatorFactoryBean;
import id.devcode.openapi.factory.ComponentFactoryBean;
import id.devcode.openapi.factory.ExtensionFactoryBean;
import id.devcode.openapi.factory.OpenApiFactoryBean;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@EnableConfigurationProperties(value={OpenApiProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Components.class, Parameter.class, SecurityScheme.class})
@PropertySource(value={"classpath:/springdoc-openapi.properties"})
public class OpenApiAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiAutoConfiguration.class);

    @Bean
    public ComponentFactoryBean components(ApplicationContext context) {
        Map parameters = context.getBeansOfType(Parameter.class);
        Map securityScheme = context.getBeansOfType(SecurityScheme.class);
        log.debug("Found {} parameters", (Object)parameters.size());
        log.debug("Found {} security scheme", (Object)securityScheme.size());
        ComponentFactoryBean componentFactoryBean = new ComponentFactoryBean();
        componentFactoryBean.setParameters(parameters);
        componentFactoryBean.setSecuritySchemes(securityScheme);
        return componentFactoryBean;
    }

    @Bean
    public OpenApiFactoryBean openApiFactoryBean(Components components, OpenApiProperties properties) {
        log.debug("Initializing open api factory bean");
        OpenApiFactoryBean openApiFactoryBean = new OpenApiFactoryBean();
        openApiFactoryBean.setComponents(components);
        openApiFactoryBean.setOpenApiProperties(properties);
        return openApiFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={OpenApiProperties.class})
    @ConditionalOnProperty(name={"springdoc.api-docs.groups.enabled"}, matchIfMissing=true)
    public ExtensionFactoryBean extensionFactoryBean(Components components, OpenApiProperties properties, @Value(value="${management.endpoints.web.base-path:/actuator}") String actuator) {
        log.debug("Initializing extension factory bean");
        ExtensionFactoryBean extensionFactoryBean = new ExtensionFactoryBean();
        extensionFactoryBean.setComponents(components);
        extensionFactoryBean.setOpenApiProperties(properties);
        extensionFactoryBean.setExtensionPath(actuator);
        return extensionFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointAutoConfiguration"})
    @ConditionalOnProperty(name={"springdoc.show-actuator", "springdoc.api-docs.groups.enabled"}, matchIfMissing=true)
    public ActuatorFactoryBean actuatorFactoryBean(Components components, OpenApiProperties properties, @Value(value="${management.endpoints.web.base-path:/actuator}") String actuator) {
        log.debug("Initializing actuator factory bean");
        ActuatorFactoryBean actuatorFactoryBean = new ActuatorFactoryBean();
        actuatorFactoryBean.setComponents(components);
        actuatorFactoryBean.setOpenApiProperties(properties);
        actuatorFactoryBean.setActuatorPath(actuator);
        return actuatorFactoryBean;
    }
}

