/*
 * Decompiled with CFR 0.152.
 */
package id.devcode.openapi.factory;

import id.devcode.openapi.factory.OpenApiSupport;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import lombok.Generated;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.FactoryBean;

public class ExtensionFactoryBean
extends OpenApiSupport
implements FactoryBean<GroupedOpenApi> {
    private String extensionPath;

    public GroupedOpenApi getObject() throws Exception {
        List<String> filterParams = List.of("page_offset", "page_size", "order_column", "order_ascending");
        return GroupedOpenApi.builder().displayName("OpenApi").group("openapi").addOpenApiCustomizer(openApi -> {
            openApi.setInfo(this.getInfoOpenApi());
            this.validateServer(openApi);
            this.applyAdditionalComponents(openApi);
            if (openApi.getPaths() == null || openApi.getPaths().isEmpty()) {
                return;
            }
            Components components = openApi.getComponents();
            if (components == null || components.getParameters() == null || components.getParameters().isEmpty()) {
                return;
            }
            List<Parameter> componentParams = components.getParameters().values().stream().filter(p -> p.getName() != null).filter(p -> !filterParams.contains(p.getName())).toList();
            openApi.getPaths().values().stream().flatMap(pathItem -> pathItem.readOperations().stream()).forEach(operation -> {
                List existingNames = operation.getParameters() == null ? List.of() : operation.getParameters().stream().map(Parameter::getName).toList();
                componentParams.stream().filter(p -> !existingNames.contains(p.getName())).forEach(arg_0 -> ((Operation)operation).addParametersItem(arg_0));
            });
        }).pathsToExclude(new String[]{this.extensionPath + "/**"}).build();
    }

    public Class<?> getObjectType() {
        return GroupedOpenApi.class;
    }

    @Generated
    public void setExtensionPath(String extensionPath) {
        this.extensionPath = extensionPath;
    }
}

