/*
 * Decompiled with CFR 0.152.
 */
package id.devcode.openapi.factory;

import id.devcode.openapi.OpenApiProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public abstract class OpenApiSupport {
    private OpenApiProperties openApiProperties;
    private Components components;

    protected OpenApiSupport() {
    }

    protected Info getInfoOpenApi() {
        Info info = new Info();
        info.setTitle(this.getOpenApiProperties().getTitle());
        info.setDescription(this.getOpenApiProperties().getDescription());
        info.setTermsOfService(this.getOpenApiProperties().getTermsOfService());
        info.setVersion(this.getOpenApiProperties().getVersion());
        info.setExtensions(this.getOpenApiProperties().getExtensions());
        info.setSummary(this.getOpenApiProperties().getSummary());
        if (this.getOpenApiProperties().getContact() != null) {
            Contact contact = new Contact();
            contact.setName(this.getOpenApiProperties().getContact().getName());
            contact.setUrl(this.getOpenApiProperties().getContact().getUrl());
            contact.setEmail(this.getOpenApiProperties().getContact().getEmail());
            contact.setExtensions(this.getOpenApiProperties().getContact().getExtensions());
            info.setContact(contact);
        }
        if (this.getOpenApiProperties().getLicense() != null) {
            License license = new License();
            license.setName(this.getOpenApiProperties().getLicense().getName());
            license.setUrl(this.getOpenApiProperties().getLicense().getUrl());
            license.setIdentifier(this.getOpenApiProperties().getLicense().getIdentifier());
            license.setExtensions(this.getOpenApiProperties().getLicense().getExtensions());
            info.license(license);
        }
        return info;
    }

    protected void validateServer(OpenAPI openApi) {
        if (this.getOpenApiProperties().getServers() != null && !this.getOpenApiProperties().getServers().isEmpty()) {
            openApi.setServers(this.getOpenApiProperties().getServers());
        }
    }

    protected void applyAdditionalComponents(OpenAPI openApi) {
        Map target;
        if (openApi == null) {
            return;
        }
        Components existing = openApi.getComponents();
        if (existing == null) {
            existing = new Components();
            openApi.setComponents(existing);
        }
        if (this.components == null) {
            return;
        }
        if (this.components.getParameters() != null && !this.components.getParameters().isEmpty()) {
            target = existing.getParameters() != null ? existing.getParameters() : new LinkedHashMap();
            this.components.getParameters().forEach(target::putIfAbsent);
            existing.setParameters(target);
        }
        if (this.components.getSecuritySchemes() != null && !this.components.getSecuritySchemes().isEmpty()) {
            target = existing.getSecuritySchemes() != null ? existing.getSecuritySchemes() : new LinkedHashMap();
            this.components.getSecuritySchemes().forEach(target::putIfAbsent);
            existing.setSecuritySchemes(target);
        }
    }

    @Generated
    public void setOpenApiProperties(OpenApiProperties openApiProperties) {
        this.openApiProperties = openApiProperties;
    }

    @Generated
    public OpenApiProperties getOpenApiProperties() {
        return this.openApiProperties;
    }

    @Generated
    public void setComponents(Components components) {
        this.components = components;
    }

    @Generated
    public Components getComponents() {
        return this.components;
    }
}

