package id.devcode.openapi;

import id.devcode.openapi.utils.Constant;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * OpenApi properties
 * @author laminalfalah on 01/09/25
 * @version 1.0.0
 */
@Data
@Valid
@ConfigurationProperties(Constant.SPRINGDOC_SWAGGER_UI_INFO)
public class OpenApiProperties {

    @NotNull
    @NotBlank
    private String title;

    private String description;

    private String termsOfService;

    private Contact contact;

    private License license;

    private String version;

    private Map<String, Object> extensions;

    private String summary;

    private List<Server> servers;

    @Data
    public static class Contact {

        private String name;

        private String url;

        private String email;

        private Map<String, Object> extensions;

    }

    @Data
    public static class License {

        private String name;

        private String url;

        private String identifier;

        private Map<String, Object> extensions;

    }

}
