package id.devcode.openapi.factory;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Map;
import lombok.Setter;
import org.springframework.beans.factory.FactoryBean;

/**
 * Factory bean for components.
 * @author laminalfalah on 01/09/25
 * @version 1.0.0
 */
public class ComponentFactoryBean implements FactoryBean<Components> {

    @Setter
    private Map<String, Parameter> parameters;

    @Setter
    private Map<String, SecurityScheme> securitySchemes;

    /**
     * Get object components.
     * @return Components
     * @throws Exception Exception
     */
    @Override
    public Components getObject() throws Exception {
        Components components = new Components();
        components.setParameters(parameters);
        components.setSecuritySchemes(securitySchemes);
        return components;
    }

    /**
     * Get object type.
     * @return Class<?> Components
     */
    @Override
    public Class<?> getObjectType() {
        return Components.class;
    }

}
