package id.devcode.openapi.factory;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import org.springframework.beans.factory.FactoryBean;

/**
 * Factory bean for open api.
 * @author laminalfalah on 01/09/25
 * @version 1.0.0
 */
public class OpenApiFactoryBean extends OpenApiSupport implements FactoryBean<OpenAPI> {

    /**
     * Get grouped open api.
     * @return grouped open api
     * @throws Exception than can be thrown by the getObject method
     */
    @Override
    public OpenAPI getObject() throws Exception {
        OpenAPI openApi = new OpenAPI();
        applyAdditionalComponents(openApi);
        validateServer(openApi);
        openApi.setInfo(getInfoOpenApi());
        if (getComponents() != null && getComponents().getSecuritySchemes() != null && !getComponents().getSecuritySchemes().isEmpty()) {
            openApi.setSecurity(getComponents().getSecuritySchemes()
                    .keySet()
                    .stream()
                    .map(k -> new SecurityRequirement().addList(k))
                    .toList()
            );
        }
        return openApi;
    }

    /**
     * Get object type.
     * @return object type
     */
    @Override
    public Class<?> getObjectType() {
        return OpenAPI.class;
    }

}
