package id.devcode.openapi.factory;

import lombok.Setter;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.FactoryBean;

/**
 * Factory bean for actuator.
 * @author laminalfalah on 01/09/25
 * @version 1.0.0
 */
public class ActuatorFactoryBean extends OpenApiSupport implements FactoryBean<GroupedOpenApi> {

    @Setter
    private String actuatorPath;

    /**
     * Get grouped open api for actuator.
     * @return grouped open api
     * @throws Exception than can be thrown by the getObject method
     */
    @Override
    public GroupedOpenApi getObject() throws Exception {
        return GroupedOpenApi.builder()
                .displayName("Actuator")
                .group("actuator")
                .addOpenApiCustomizer(openApi -> {
                    openApi.setInfo(getInfoOpenApi());
                    validateServer(openApi);
                    applyAdditionalComponents(openApi);
                })
                .pathsToMatch(actuatorPath + "/**")
                .build();
    }

    /**
     * Get object type.
     * @return object type
     */
    @Override
    public Class<?> getObjectType() {
        return GroupedOpenApi.class;
    }

}
