package id.devcode.openapi.factory;

import id.devcode.openapi.OpenApiProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Getter;
import lombok.Setter;

/**
 * Open api support.
 * @author laminalfalah on 10/08/2021
 * @version 1.0.0
 */
public abstract class OpenApiSupport {

    @Setter
    @Getter
    private OpenApiProperties openApiProperties;

    @Setter
    @Getter
    private Components components;

    /**
     * Get info open api.
     * @return info open api
     */
    protected Info getInfoOpenApi() {
        Info info = new Info();
        info.setTitle(openApiProperties.getTitle());
        info.setDescription(openApiProperties.getDescription());
        info.setTermsOfService(openApiProperties.getTermsOfService());
        info.setVersion(openApiProperties.getVersion());
        info.setExtensions(openApiProperties.getExtensions());
        info.setSummary(openApiProperties.getSummary());

        if (openApiProperties.getContact() != null) {
            Contact contact = new Contact();
            contact.setName(openApiProperties.getContact().getName());
            contact.setUrl(openApiProperties.getContact().getUrl());
            contact.setEmail(openApiProperties.getContact().getEmail());
            contact.setExtensions(openApiProperties.getContact().getExtensions());
            info.setContact(contact);
        }

        if (openApiProperties.getLicense() != null) {
            License license = new License();
            license.setName(openApiProperties.getLicense().getName());
            license.setUrl(openApiProperties.getLicense().getUrl());
            license.setIdentifier(openApiProperties.getLicense().getIdentifier());
            license.setExtensions(openApiProperties.getLicense().getExtensions());
            info.license(license);
        }

        return info;
    }

    /**
     * Validate server.
     * @param openApi open api
     */
    protected void validateServer(OpenAPI openApi) {
        if (getOpenApiProperties().getServers() != null && !getOpenApiProperties().getServers().isEmpty()) {
            openApi.setServers(getOpenApiProperties().getServers());
        }
    }

    /**
     * Apply additional components.
     * @param openApi open api
     */
    protected void applyAdditionalComponents(OpenAPI openApi) {
        if (openApi == null) {
            return;
        }
        Components existing = openApi.getComponents();
        if (existing == null) {
            existing = new Components();
            openApi.setComponents(existing);
        }
        if (this.components == null) {
            return;
        }

        if (this.components.getParameters() != null && !this.components.getParameters().isEmpty()) {
            Map<String, Parameter> target = existing.getParameters() != null ? existing.getParameters() : new LinkedHashMap<>();
            this.components.getParameters().forEach(target::putIfAbsent);
            existing.setParameters(target);
        }

        if (this.components.getSecuritySchemes() != null && !this.components.getSecuritySchemes().isEmpty()) {
            Map<String, SecurityScheme> target = existing.getSecuritySchemes() != null ? existing.getSecuritySchemes() : new LinkedHashMap<>();
            this.components.getSecuritySchemes().forEach(target::putIfAbsent);
            existing.setSecuritySchemes(target);
        }
    }

}
