/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.api;

public final class GeoEntity {
    private final String city;
    private final String country;
    private final String province;
    private final String countryCode;
    private final String isp;
    private final String district;
    private final String zipCode;
    private final Double lat;
    private final Double lng;
    private final String timezone;
    private final String connectionType;
    private final String org;

    public GeoEntity(Builder builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.province = builder.province;
        this.countryCode = builder.countryCode;
        this.isp = builder.isp;
        this.district = builder.district;
        this.zipCode = builder.zipCode;
        this.lat = builder.lat;
        this.lng = builder.lng;
        this.timezone = builder.timezone;
        this.connectionType = builder.connectionType;
        this.org = builder.org;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getProvince() {
        return this.province;
    }

    public String getDistrict() {
        return this.district;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLng() {
        return this.lng;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getOrg() {
        return this.org;
    }

    public String toString() {
        return "GeoEntity{city='" + this.city + '\'' + ", country='" + this.country + '\'' + ", province='" + this.province + '\'' + ", countryCode='" + this.countryCode + '\'' + ", isp='" + this.isp + '\'' + ", district='" + this.district + '\'' + ", zipCode='" + this.zipCode + '\'' + ", lat=" + this.lat + ", lng=" + this.lng + ", timezone='" + this.timezone + '\'' + ", connectionType='" + this.connectionType + '\'' + ", org='" + this.org + '\'' + '}';
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getIsp() {
        return this.isp;
    }

    public static class Builder {
        private String countryCode;
        private String city;
        private String country;
        private String province;
        private String isp;
        private String district;
        private String zipCode;
        private Double lat;
        private Double lng;
        private String timezone;
        private String connectionType;
        private String org;

        public Builder withDistrict(String district) {
            this.district = district;
            return this;
        }

        public Builder withConnType(String connType) {
            this.connectionType = connType;
            return this;
        }

        public Builder withZipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder withLat(Double lat) {
            this.lat = lat;
            return this;
        }

        public Builder withLng(Double lng) {
            this.lng = lng;
            return this;
        }

        public Builder withTimezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder withOrg(String org) {
            this.org = org;
            return this;
        }

        public Builder withIsp(String isp) {
            this.isp = isp;
            return this;
        }

        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder withProvince(String province) {
            this.province = province;
            return this;
        }

        public GeoEntity build() {
            return new GeoEntity(this);
        }
    }
}

