/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.importer;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.net.InetAddresses;
import in.ankushs.dbip.model.GeoAttributesImpl;
import in.ankushs.dbip.parser.CsvParser;
import in.ankushs.dbip.parser.CsvParserImpl;
import in.ankushs.dbip.repository.DbIpRepository;
import in.ankushs.dbip.repository.JavaMapDbIpRepositoryImpl;
import in.ankushs.dbip.utils.CountryResolver;
import in.ankushs.dbip.utils.GzipUtils;
import in.ankushs.dbip.utils.PreConditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceImporter {
    private static final Logger logger = LoggerFactory.getLogger(ResourceImporter.class);
    private final DbIpRepository repository = JavaMapDbIpRepositoryImpl.getInstance();
    private final CsvParser csvParser = CsvParserImpl.getInstance();
    private static ResourceImporter instance = null;
    private Interner<String> interner = Interners.newWeakInterner();

    private ResourceImporter() {
    }

    public static ResourceImporter getInstance() {
        if (instance == null) {
            return new ResourceImporter();
        }
        return instance;
    }

    public void load(File file) {
        try {
            PreConditions.checkExpression(!GzipUtils.isGzipped(file), "Not a  gzip file");
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        String[] array = null;
        try (FileInputStream fis = new FileInputStream(file);
             GZIPInputStream gis = new GZIPInputStream(fis);
             InputStreamReader decorator = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(decorator);){
            logger.debug("Reading dbip data from {}", (Object)file.getName());
            String line = null;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                ++i;
                array = this.csvParser.parseRecord(line);
                String district = "";
                Double lat = null;
                Double lng = null;
                String timezone = "";
                String connType = "";
                String org = "";
                String isp = "";
                String zipCode = "";
                try {
                    district = (String)this.interner.intern((Object)array[4]);
                    zipCode = (String)this.interner.intern((Object)array[6]);
                    lat = Double.valueOf(array[7]);
                    lng = Double.valueOf(array[8]);
                    timezone = (String)this.interner.intern((Object)array[10]);
                    isp = (String)this.interner.intern((Object)array[12]);
                    connType = (String)this.interner.intern((Object)array[13]);
                    org = (String)this.interner.intern((Object)array[14]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GeoAttributesImpl geoAttributes = new GeoAttributesImpl.Builder().withStartInetAddress(InetAddresses.forString((String)array[0])).withEndInetAddress(InetAddresses.forString((String)array[1])).withCountryCode(array[2]).withCountry(CountryResolver.resolveToFullName(array[2])).withProvince((String)this.interner.intern((Object)array[3])).withCity((String)this.interner.intern((Object)array[5])).withIsp(isp).withDistrict(district).withConnType(connType).withZipCode(zipCode).withLat(lat).withLng(lng).withTimezone(timezone).withOrg(org).build();
                this.repository.save(geoAttributes);
                if (i % 100000 != 0) continue;
                logger.debug("Loaded {} entries", (Object)i);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

