/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.utils.parser;

import in.ashwanthkumar.utils.func.Function;
import in.ashwanthkumar.utils.lang.tuple.Tuple2;
import in.ashwanthkumar.utils.parser.Failure;
import in.ashwanthkumar.utils.parser.ParserResult;
import in.ashwanthkumar.utils.parser.Success;

public abstract class Parser<T> {
    private String name = "";

    public abstract ParserResult<T> parse(String var1);

    public Parser<T> named(String name) {
        this.name = name;
        return this;
    }

    public <U> Parser<U> map(final Function<T, U> transform) {
        final Parser me = this;
        return new Parser<U>(){

            @Override
            public ParserResult<U> parse(String input) {
                return me.parse(input).map(transform);
            }
        };
    }

    public <U> Parser<U> thenR(final Parser<U> another) {
        final Parser me = this;
        return new Parser<U>(){

            @Override
            public ParserResult<U> parse(String input) {
                ParserResult myResult = me.parse(input);
                return myResult.successful() ? another.parse(myResult.getRemainingInput()) : Failure.of(((Failure)myResult).getMessage(), myResult.getRemainingInput());
            }
        }.named(this.name + " ~> " + another.name);
    }

    public <U> Parser<T> thenL(final Parser<U> another) {
        final Parser me = this;
        return new Parser<T>(){

            @Override
            public ParserResult<T> parse(String input) {
                ParserResult myResult = me.parse(input);
                if (myResult.successful()) {
                    ParserResult anotherResult = another.parse(myResult.getRemainingInput());
                    return myResult.successful() && anotherResult.successful() ? myResult.setRemainingInput(anotherResult.getRemainingInput()) : Failure.of(((Failure)anotherResult).getMessage(), myResult.getRemainingInput());
                }
                return myResult;
            }
        }.named(this.name + " <~ " + another.name);
    }

    public <U> Parser<Tuple2<T, U>> then(final Parser<U> another) {
        final Parser me = this;
        return new Parser<Tuple2<T, U>>(){

            @Override
            public ParserResult<Tuple2<T, U>> parse(String input) {
                ParserResult myResult = me.parse(input);
                if (myResult.successful()) {
                    ParserResult anotherResult = another.parse(myResult.getRemainingInput());
                    return myResult.successful() && anotherResult.successful() ? Success.of(Tuple2.tuple2(myResult.get(), anotherResult.get()), anotherResult.getRemainingInput()) : Failure.of(((Failure)anotherResult).getMessage(), anotherResult.getRemainingInput());
                }
                return Failure.of(((Failure)myResult).getMessage(), myResult.getRemainingInput());
            }
        }.named(this.name + " ~ " + another.name);
    }

    public Parser<T> or(final Parser<T> another) {
        final Parser me = this;
        return new Parser<T>(){

            @Override
            public ParserResult<T> parse(String input) {
                ParserResult myResult = me.parse(input);
                return myResult.successful() ? myResult : another.parse(input);
            }
        };
    }

    public Parser<T> debug() {
        final Parser me = this;
        return new Parser<T>(){

            @Override
            public ParserResult<T> parse(String input) {
                System.out.println("Trying " + me.name + " at '" + input + "'");
                ParserResult result = me.parse(input);
                System.out.println(me.name + " --> " + result);
                return result;
            }
        };
    }

    public Parser<T> skip(final int nChars) {
        assert (nChars > 0);
        final Parser me = this;
        return new Parser<T>(){

            @Override
            public ParserResult<T> parse(String input) {
                return me.parse(input.substring(nChars - 1));
            }
        };
    }
}

