/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.api;

import ar.com.dgarcia.javaspec.api.JavaSpecApi;
import ar.com.dgarcia.javaspec.api.contexts.TestContext;
import ar.com.dgarcia.javaspec.api.exceptions.FailingRunnable;
import ar.com.dgarcia.javaspec.api.exceptions.SpecException;
import ar.com.dgarcia.javaspec.impl.DefinitionMode;
import ar.com.dgarcia.javaspec.impl.model.SpecTree;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Consumer;

public abstract class JavaSpec<T extends TestContext>
implements JavaSpecApi<T> {
    private JavaSpecApi<T> currentMode;

    public abstract void define();

    public void populate(SpecTree specTree) {
        DefinitionMode<T> definitionMode = DefinitionMode.create(specTree, this.getContextTypeFromSubclassDeclaration());
        this.currentMode = definitionMode;
        this.define();
        this.currentMode = definitionMode.changeToRunning();
    }

    public Class<T> getContextTypeFromSubclassDeclaration() {
        Class<?> subClass = this.getClass();
        if (!subClass.getSuperclass().equals(JavaSpec.class)) {
            throw new SpecException("A java spec class[" + subClass + "] must inherit directly from " + JavaSpec.class);
        }
        Type generifiedJavaSpec = subClass.getGenericSuperclass();
        if (!(generifiedJavaSpec instanceof ParameterizedType)) {
            throw new SpecException("JavaSpec superclass must be generified with a type of TestContext. For example JavaSpec<TestContext>");
        }
        Type contextType = ((ParameterizedType)generifiedJavaSpec).getActualTypeArguments()[0];
        return this.getClassInstanceFromArgument(contextType);
    }

    private Class<T> getClassInstanceFromArgument(Type contextType) throws SpecException {
        if (contextType instanceof ParameterizedType) {
            ParameterizedType parameterizedArgument = (ParameterizedType)contextType;
            Type rawType = parameterizedArgument.getRawType();
            if (!Class.class.isInstance(rawType)) {
                throw new SpecException("JavaSpec parameterization can't reference a generic type: " + rawType);
            }
            return (Class)rawType;
        }
        if (!Class.class.isInstance(contextType)) {
            throw new SpecException("JavaSpec generic parameter can't be a type wildcard: " + contextType);
        }
        return (Class)contextType;
    }

    @Override
    public T context() {
        return this.currentMode.context();
    }

    @Override
    public void xdescribe(String aGroupName, Runnable aGroupDefinition) {
        this.currentMode.xdescribe(aGroupName, aGroupDefinition);
    }

    @Override
    public void xdescribe(Class<?> aGroupName, Runnable aGroupDefinition) {
        this.currentMode.xdescribe(aGroupName, aGroupDefinition);
    }

    @Override
    public void describe(Class<?> aClass, Runnable aGroupDefinition) {
        this.currentMode.describe(aClass, aGroupDefinition);
    }

    @Override
    public void describe(String aGroupName, Runnable aGroupDefinition) {
        this.currentMode.describe(aGroupName, aGroupDefinition);
    }

    @Override
    public void xit(String testName, Runnable aTestCode) {
        this.currentMode.xit(testName, aTestCode);
    }

    @Override
    public void it(String testName) {
        this.currentMode.it(testName);
    }

    @Override
    public void it(String testName, Runnable aTestCode) {
        this.currentMode.it(testName, aTestCode);
    }

    @Override
    public void afterEach(Runnable aCodeBlock) {
        this.currentMode.afterEach(aCodeBlock);
    }

    @Override
    public void beforeEach(Runnable aCodeBlock) {
        this.currentMode.beforeEach(aCodeBlock);
    }

    @Override
    public void given(Runnable setupCode) {
        this.currentMode.given(setupCode);
    }

    @Override
    public void when(Runnable exerciseCode) {
        this.currentMode.when(exerciseCode);
    }

    @Override
    public void then(Runnable assertionCode) {
        this.currentMode.then(assertionCode);
    }

    @Override
    public void itThen(String testName, Runnable assertionCode) {
        this.currentMode.itThen(testName, assertionCode);
    }

    @Override
    public void executeAsGivenWhenThenTest() {
        this.currentMode.executeAsGivenWhenThenTest();
    }

    @Override
    public <X extends Throwable> void itThrows(Class<X> expectedExceptionType, String testNameSuffix, FailingRunnable<X> aTestCode, Consumer<X> exceptionAssertions) throws SpecException {
        this.currentMode.itThrows(expectedExceptionType, testNameSuffix, aTestCode, exceptionAssertions);
    }
}

