/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.api;

import ar.com.dgarcia.javaspec.api.JavaSpec;
import ar.com.dgarcia.javaspec.impl.junit.JunitTestCode;
import ar.com.dgarcia.javaspec.impl.junit.JunitTestTreeAdapter;
import ar.com.dgarcia.javaspec.impl.model.SpecTree;
import ar.com.dgarcia.javaspec.impl.parser.SpecParser;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class JavaSpecRunner
extends Runner {
    private Class<? extends JavaSpec> clase;
    private JunitTestTreeAdapter junitAdapter;

    public JavaSpecRunner(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        if (!JavaSpec.class.isAssignableFrom(klass)) {
            throw new InitializationError("Your class[" + klass + "] must extend " + JavaSpec.class + " to be run with " + JavaSpecRunner.class.getSimpleName());
        }
        this.clase = klass;
        this.createJunitTestTreeFromSpecClass();
    }

    private void createJunitTestTreeFromSpecClass() throws InitializationError {
        SpecTree specTree = SpecParser.create().parse(this.clase);
        if (specTree.hasNoTests()) {
            throw new InitializationError("The spec class[" + this.clase.getSimpleName() + "] has no tests. You must at least use one it() or one xit() inside your definition method");
        }
        this.junitAdapter = JunitTestTreeAdapter.create(specTree, this.clase);
    }

    public Description getDescription() {
        return this.junitAdapter.getJunitTree().getJunitDescription();
    }

    public void run(RunNotifier notifier) {
        List<JunitTestCode> adaptedTests = this.junitAdapter.getJunitTree().getJunitTests();
        for (JunitTestCode adaptedTest : adaptedTests) {
            adaptedTest.executeNotifying(notifier);
        }
    }
}

