/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.context.typed;

import ar.com.dgarcia.javaspec.api.contexts.TestContext;
import ar.com.dgarcia.javaspec.api.variable.Variable;
import ar.com.dgarcia.javaspec.impl.context.typed.TypedContextMethodInvocation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Supplier;

public class TypedContextProxyHandler
implements InvocationHandler {
    private Variable<TestContext> currentContext;

    public static TypedContextProxyHandler create(Variable<TestContext> sharedVariable) {
        TypedContextProxyHandler handler = new TypedContextProxyHandler();
        handler.currentContext = sharedVariable;
        return handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        TypedContextMethodInvocation methodInvocation = TypedContextMethodInvocation.create(method, args);
        Function<TestContext, Object> operation = this.createOperationBasedOn(methodInvocation);
        return operation.apply(this.currentContext.get());
    }

    private Function<TestContext, Object> createOperationBasedOn(TypedContextMethodInvocation methodInvocation) {
        if (methodInvocation.canBeHandledByTestContext(this.currentContext.get())) {
            return methodInvocation::invokeOn;
        }
        String variableName = methodInvocation.getVariableName();
        Supplier<Object> variableDefinition = methodInvocation.getVariableDefinitionArgument();
        if (variableDefinition != null) {
            return testContext -> {
                testContext.let(variableName, variableDefinition);
                return null;
            };
        }
        return testContext -> testContext.get(variableName);
    }
}

