/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.junit;

import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

public class JunitTestCode {
    private Runnable testCode;
    private Description testDescription;
    private boolean mustIgnore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNotifying(RunNotifier notifier) {
        EachTestNotifier testNotifier = new EachTestNotifier(notifier, this.testDescription);
        if (this.mustIgnore) {
            testNotifier.fireTestIgnored();
            return;
        }
        testNotifier.fireTestStarted();
        try {
            this.testCode.run();
        }
        catch (AssumptionViolatedException e) {
            testNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            testNotifier.addFailure(e);
        }
        finally {
            testNotifier.fireTestFinished();
        }
    }

    public static JunitTestCode create(Runnable testCode, Description testDescription) {
        JunitTestCode junitTestCode = new JunitTestCode();
        junitTestCode.testCode = testCode;
        junitTestCode.testDescription = testDescription;
        junitTestCode.mustIgnore = false;
        return junitTestCode;
    }

    public void ignoreTest() {
        this.mustIgnore = true;
    }

    public Description getTestDescription() {
        return this.testDescription;
    }
}

