/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.modes;

import ar.com.dgarcia.javaspec.api.JavaSpecApi;
import ar.com.dgarcia.javaspec.api.contexts.ClassBasedTestContext;
import ar.com.dgarcia.javaspec.api.contexts.TestContext;
import ar.com.dgarcia.javaspec.api.exceptions.FailingRunnable;
import ar.com.dgarcia.javaspec.api.exceptions.SpecException;
import ar.com.dgarcia.javaspec.api.variable.Let;
import ar.com.dgarcia.javaspec.api.variable.Variable;
import ar.com.dgarcia.javaspec.impl.context.typed.TypedContextFactory;
import ar.com.dgarcia.javaspec.impl.model.SpecGroup;
import ar.com.dgarcia.javaspec.impl.model.SpecTree;
import ar.com.dgarcia.javaspec.impl.model.impl.GroupSpecDefinition;
import ar.com.dgarcia.javaspec.impl.model.impl.TestSpecDefinition;
import ar.com.dgarcia.javaspec.impl.modes.RunningMode;
import ar.com.dgarcia.javaspec.impl.parser.SpecStack;
import java.util.function.Consumer;

public class DefinitionMode<T extends TestContext>
implements JavaSpecApi<T> {
    private SpecStack stack;
    private SpecTree specTree;
    private T typedContext;
    private RunningMode<T> runningMode;

    @Override
    public void beforeEach(Runnable aCodeBlock) {
        this.stack.getCurrentHead().addBeforeBlock(aCodeBlock);
    }

    @Override
    public void afterEach(Runnable aCodeBlock) {
        this.stack.getCurrentHead().addAfterBlock(aCodeBlock);
    }

    @Override
    public void it(String testName, Runnable aTestCode) {
        TestSpecDefinition createdSpec = TestSpecDefinition.create(testName, aTestCode, this.specTree.getSharedContext());
        this.stack.getCurrentHead().addTest(createdSpec);
    }

    @Override
    public void it(String testName) {
        TestSpecDefinition createdSpec = TestSpecDefinition.createPending(testName, this.specTree.getSharedContext());
        this.stack.getCurrentHead().addTest(createdSpec);
    }

    @Override
    public void xit(String testName, Runnable aTestCode) {
        TestSpecDefinition createdSpec = TestSpecDefinition.create(testName, aTestCode, this.specTree.getSharedContext());
        createdSpec.markAsPending();
        this.stack.getCurrentHead().addTest(createdSpec);
    }

    @Override
    public <X extends Throwable> void itThrows(Class<X> expectedExceptionType, String testNameSuffix, FailingRunnable<X> aTestCode, Consumer<X> exceptionAssertions) throws SpecException {
        String expectedTypeName = expectedExceptionType.getSimpleName();
        String testName = "throws " + expectedTypeName + " " + testNameSuffix;
        Runnable testCode = () -> {
            try {
                aTestCode.run();
                throw new AssertionError((Object)("No exception thrown while expecting: " + expectedTypeName));
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable e) {
                if (!expectedExceptionType.isAssignableFrom(e.getClass())) {
                    throw new AssertionError("Caught " + e + " while expecting " + expectedTypeName, e);
                }
                exceptionAssertions.accept(e);
                return;
            }
        };
        this.it(testName, testCode);
    }

    @Override
    public void describe(String aGroupName, Runnable aGroupDefinition) {
        this.createGroupDefinition(aGroupName, aGroupDefinition);
    }

    @Override
    public void xdescribe(String aGroupName, Runnable aGroupDefinition) {
        GroupSpecDefinition createdGroup = this.createGroupDefinition(aGroupName, aGroupDefinition);
        createdGroup.markAsDisabled();
    }

    @Override
    public void describe(Class<?> aClass, Runnable aGroupDefinition) {
        this.createClassBasedGroupDescription(aClass, aGroupDefinition);
    }

    @Override
    public void xdescribe(Class<?> aClass, Runnable aGroupDefinition) {
        GroupSpecDefinition groupDefinition = this.createClassBasedGroupDescription(aClass, aGroupDefinition);
        groupDefinition.markAsDisabled();
    }

    private GroupSpecDefinition createClassBasedGroupDescription(Class<?> aClass, Runnable aGroupDefinition) {
        if (!ClassBasedTestContext.class.isInstance(this.context())) {
            throw new SpecException("#describe can't be called with a class if the test context is not a ClassBasedTestContext subtype");
        }
        String groupName = "class: " + aClass.getSimpleName();
        GroupSpecDefinition groupDefinition = this.createGroupDefinition(groupName, aGroupDefinition);
        ClassBasedTestContext classContext = (ClassBasedTestContext)((Object)groupDefinition.getTestContext());
        classContext.describedClass(() -> aClass);
        return groupDefinition;
    }

    private GroupSpecDefinition createGroupDefinition(String aGroupName, Runnable aGroupDefinition) {
        GroupSpecDefinition createdGroup = GroupSpecDefinition.create(aGroupName);
        this.stack.executeAsCurrent(createdGroup, aGroupDefinition);
        this.stack.getCurrentHead().addSubGroup(createdGroup);
        return createdGroup;
    }

    @Override
    public T context() {
        return this.typedContext;
    }

    @Override
    public <X> Let<X> localLet(String variableName) {
        return Let.create(variableName, this::context);
    }

    @Override
    public void given(Runnable setupCode) {
        this.context().setupCode(() -> setupCode);
    }

    @Override
    public void when(Runnable exerciseCode) {
        this.context().exerciseCode(() -> exerciseCode);
    }

    @Override
    public void then(Runnable assertionCode) {
        this.context().assertionCode(() -> assertionCode);
    }

    @Override
    public void itThen(String testName, Runnable assertionCode) {
        this.it(testName, () -> this.runningMode.then(assertionCode));
    }

    @Override
    public void executeAsGivenWhenThenTest() {
        throw new SpecException("Execution can't be done outside a test. it must be called inside an it() lambda");
    }

    public static <T extends TestContext> DefinitionMode<T> create(SpecTree specTree, Class<T> expectedContextType) {
        DefinitionMode<T> describer = new DefinitionMode<T>();
        describer.specTree = specTree;
        super.initialize(expectedContextType);
        return describer;
    }

    private void initialize(Class<T> expectedContextType) {
        SpecGroup rootGroup = this.specTree.getRootGroup();
        Variable<TestContext> sharedContext = this.specTree.getSharedContext();
        this.stack = SpecStack.create(rootGroup, sharedContext);
        this.typedContext = TypedContextFactory.createInstanceOf(expectedContextType, sharedContext);
        this.runningMode = RunningMode.create(this.context());
    }

    public RunningMode<T> changeToRunning() {
        return this.runningMode;
    }
}

