/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.api.variable;

public class Variable<T> {
    private T value;

    public static <T> Variable<T> create() {
        return Variable.of(null);
    }

    public T get() {
        return this.value;
    }

    public static <T> Variable<T> of(T initialValue) {
        Variable<T> variable = new Variable<T>();
        variable.set(initialValue);
        return variable;
    }

    public Variable<T> set(T newValue) {
        this.value = newValue;
        return this;
    }

    public Variable<T> clean() {
        this.value = null;
        return this;
    }

    public Variable<T> storeSumWith(T operand) throws UnsupportedOperationException {
        if (this.value instanceof Integer) {
            Integer currentValue = (Integer)this.value;
            int result = currentValue + ((Number)operand).intValue();
            this.value = result;
        } else if (this.value instanceof Double) {
            Double currentValue = (Double)this.value;
            double result = currentValue + ((Number)operand).doubleValue();
            this.value = result;
        } else if (this.value instanceof String) {
            String currentValue = (String)this.value;
            String result = currentValue + operand;
            this.value = result;
        } else {
            throw new UnsupportedOperationException("Sum is not supported for value [" + this.value + "] and operand [" + operand + "]");
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public <R> R castedTo(Class<R> expectedClass) {
        return (R)this.get();
    }
}

